<?PHP
#
#   FILE:  SPT--AccessPreferencesDetailedComplete.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   OPTIONAL FUNCTIONS:
#
#   FORM FIELDS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("Accessibility Preferences Saved");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# if user is logged in and came here from AccessPreferencesDetailed OR
# AccessPreferences with all options turned off
if ($User->IsLoggedIn() && 
        (isset($_POST["Submit"]) && 
        $_POST["Submit"] == "Save Preferences") ||
        $Session->Get("Submit") == "Continue")
{
    # for the following values that allow custom values, allow the
    # user to just enter a new custom value, or select a new value from
    # the option list
    # whatever has changed takes precedence, EG:
    # if the old values were "custom" and "MyFont"
    # and the new values are "Arial" and "MyFont"
    # then the value saved would be "Arial".
    # Or, if the old values were "Arial" and "" and the new values
    # are "Arial" and "MyFont" then the value saved would be "MyFont".

    # if new custom font size specified
    if (isset($_POST["F_FontSizeCustom"])
            && ($_POST["F_FontSizeCustom"] > 0)
            && ($_POST["F_FontSizeCustom"] != $User->PrefFontSize()))
    {
        # set font size to specified custom value
        $User->PrefFontSize($_POST["F_FontSizeCustom"]);
    }
    # else if font size specified
    elseif (isset($_POST["F_FontSize"]) && ($_POST["F_FontSize"] > 0))
    {
        # set font size to specified value
        $User->PrefFontSize($_POST["F_FontSize"]);
    }
    # else set to default
    else
    {
        $User->PrefFontSize(0);
    }

    # if plausible custom font face specified
    if (isset($_POST["F_FontFaceCustom"])
                && strlen($_POST["F_FontFaceCustom"])
                && $_POST["F_FontFaceCustom"] != "Enter a Font Name"
                && ($_POST["F_FontFace"] == $User->PrefFontTypeFace()
                    || $_POST["F_FontFace"] == "custom"))
    {
        # set font type face to specified custom value
        $User->PrefFontTypeFace($_POST["F_FontFaceCustom"]);
    }
    # else if font type face specified
    elseif (isset($_POST["F_FontFace"]) &&
        $_POST["F_FontFace"] != "custom")
    {
        $User->PrefFontTypeFace($_POST["F_FontFace"]);
    }
    # else set to default
    else
    {
        $User->PrefFontTypeFace("");
    }

    # if plausible custom font color specified
    if (isset($_POST["F_FontColorCustom"])
                && ($_POST["F_FontColorCustom"] != "Enter a Font Color")
                && strlen($_POST["F_FontColorCustom"])
                && ($_POST["F_FontColor"] == $User->PrefFontColor()
                    || $_POST["F_FontColor"] == "custom"))
    {
        # set font color to specified custom value
        $User->PrefFontColor($_POST["F_FontColorCustom"]);
    }
    # else if font color specified
    elseif (isset($_POST["F_FontColor"]) &&
        $_POST["F_FontColor"] != "custom")
    {
        # set font color to specified value
        $User->PrefFontColor($_POST["F_FontColor"]);
    }
    # else set to default
    else
    {
        $User->PrefFontColor("");
    }

    # if plausible custom background color specified
    if (isset($_POST["F_BackgroundColorCustom"])
            && ($_POST["F_BackgroundColorCustom"] !="Enter a Background Color")
            && strlen($_POST["F_BackgroundColorCustom"])
            && ($_POST["F_BackgroundColor"] == $User->PrefBackgroundColor()
                || $_POST["F_BackgroundColor"] == "custom")) 
    {
        # set background color to specified custom value
        $User->PrefBackgroundColor($_POST["F_BackgroundColorCustom"]);
    }
    # else if background color specified
    elseif (isset($_POST["F_BackgroundColor"]) &&
        $_POST["F_BackgroundColor"] != "custom")
    {
        # set background color to specified value
        $User->PrefBackgroundColor($_POST["F_BackgroundColor"]);
    }
    # else set to default
    else
    {
        $User->PrefBackgroundColor("");
    }

    # color avoidance 
    $ColorAvoidanceFlags = 0;
    if (isset($_POST["F_AvoidRed"]))
        $ColorAvoidanceFlags |= $_POST["F_AvoidRed"];
    if (isset($_POST["F_AvoidRedGreen"]))
        $ColorAvoidanceFlags |= $_POST["F_AvoidRedGreen"];
    if (isset($_POST["F_AvoidBlueYellow"]))
        $ColorAvoidanceFlags |= $_POST["F_AvoidBlueYellow"];
    if (isset($_POST["F_AvoidGreenYellow"]))
        $ColorAvoidanceFlags |= $_POST["F_AvoidGreenYellow"];
    if (isset($_POST["F_AvoidOrange"]))
        $ColorAvoidanceFlags |= $_POST["F_AvoidOrange"];
    if (isset($_POST["F_AvoidRedBlack"]))
        $ColorAvoidanceFlags |= $_POST["F_AvoidRedBlack"];
    if (isset($_POST["F_AvoidPurpleGrey"]))
        $ColorAvoidanceFlags |= $_POST["F_AvoidPurpleGrey"];
    if (isset($_POST["F_UseMaximumContrast"]))
        $ColorAvoidanceFlags |= $_POST["F_UseMaximumContrast"];

    $User->PrefColorAvoidanceFlags($ColorAvoidanceFlags);        
   
    # Content density
    if (isset($_POST["F_ContentDensity"]))
        $User->PrefContentDensity($_POST["F_ContentDensity"]);
    else
        $User->PrefContentDensity(UIPREF_CONTENTDENSITY_NOPREFERENCE);

    # Content view
    if (isset($_POST["F_ContentViews"]))
        $User->PrefContentView($_POST["F_ContentViews"]);
    else
        $User->PrefContentView(UIPREF_CONTENTVIEW_NOPREFERENCE);

    # Audio description level
    if (isset($_POST["F_AudioDescription"]))
        $User->PrefAudioDescriptionLevel($_POST["F_AudioDescription"]);
    else
        $User->PrefAudioDescriptionLevel(UIPREF_AUDIODESCRIPTION_NONE);

    # Audio description language
    if (isset($_POST["F_AudioDescriptionLang"]))
        $User->PrefAudioDescriptionLanguage($_POST["F_AudioDescriptionLang"]);
    else
        $User->PrefAudioDescriptionLanguage("English");

    # visual description language
    if (isset($_POST["F_AltTextLang"]))
        $User->PrefVisualDescriptionLanguage($_POST["F_AltTextLang"]);
    else
        $User->PrefVisualDescriptionLanguage("English");

    # use graphic alternatives 
    if (isset($_POST["F_GraphicAlternative"]))
        $User->PrefUseGraphicAlternatives($_POST["F_GraphicAlternative"]);
    else
        $User->PrefUseGraphicAlternatives("0");

    # use sign language 
    if (isset($_POST["F_SignLanguage"]) &&
                            $_POST["F_SignLanguage"] != "None")
        $User->PrefSignLanguage($_POST["F_SignLanguage"]);
    else
        $User->PrefSignLanguage("None");

    # use captions for auditory content 
    if (isset($_POST["F_CaptionType"]) &&
                            $_POST["F_CaptionType"] != "None")
        $User->PrefCaptionType($_POST["F_CaptionType"]);
    else
        $User->PrefCaptionType(UIPREF_CAPTIONTYPE_NONE);
    
    # set caption rate for auditory content 
    if (isset($_POST["F_CaptionRate"]) &&
                            (strval(doubleval($_POST["F_CaptionRate"]))
                                == trim($_POST["F_CaptionRate"])))
        $User->PrefCaptionRate(min(max($_POST["F_CaptionRate"], 1), 300));
    else
        $User->PrefCaptionRate(120);
}
# Cancel selected
else
{
    PrintAutoRefreshPage("Home", "SPT--Home.php");
    exit;
}

include("include/SPT--StandardHtmlPageLoad.php");

?>
