-- update SystemConfiguration to reflect ability to enter in search engine keywords
ALTER TABLE SystemConfiguration
    ADD COLUMN SiteKeywords TEXT
    AFTER OaiDateGranularity;

-- update SystemConfiguration to allow for OAI-SQ disabling
ALTER TABLE SystemConfiguration
    ADD COLUMN  OAISQEnabled INT DEFAULT 1 NOT NULL AFTER RecommenderDBEnabled;

-- update to RSS Export configuration
ALTER TABLE RSSConfiguration
    ADD COLUMN NotifyBrowser INT DEFAULT 0 NOT NULL AFTER EntriesToPublish;

-- updates for new RSS Import Feeds
CREATE TABLE RSSFeeds(
    RSSId                   INT NOT NULL AUTO_INCREMENT,
    Title                   TEXT,
    URL                     TEXT,
    DisplayLocations        INT NOT NULL,
    NumberItemsToDisplay    INT,
    RefreshRate             INT NOT NULL,
    Enabled                 INT DEFAULT 0 NOT NULL,
    INDEX                   (RSSId)
);

-- add fulltext index for classification searching
ALTER TABLE Classifications ADD FULLTEXT(SegmentName, ClassificationName);

-- add at least one variant name to avoid MySQL-related problem
INSERT INTO VariantNames (ControlledNameId, VariantName) VALUES (-1, "DUMMY");

-- saved searches           
CREATE TABLE SavedSearches (
    SearchId            INT NOT NULL AUTO_INCREMENT,
    SearchName          TEXT,
    UserId              INT NOT NULL,
    DateLastRun         TIMESTAMP,
    Frequency           INT,
    INDEX               (UserId),
    INDEX               (SearchId)
);  
    
-- saved search text parameters
CREATE TABLE SavedSearchTextParameters (
    SearchId            INT NOT NULL,
    FieldId             INT,
    SearchText          TEXT,
    INDEX               (SearchId)
);
    
-- saved search value ID parameters (used for controlled names, options, etc)
CREATE TABLE SavedSearchIdParameters (
    SearchId            INT NOT NULL,
    FieldId             INT,    
    SearchValueId       INT,    
    INDEX               (SearchId)
);  

-- OAI-SQ search sites
CREATE TABLE GlobalSearchSites(
    SiteId                      INT NOT NULL AUTO_INCREMENT,
    SiteName                    TEXT,
    OaiUrl                      TEXT,
    SiteUrl                     TEXT,
    LastSearchDate              DATETIME,
    ConsecutiveFailures         INT DEFAULT 0,
    SearchAttempts              INT DEFAULT 0,
    SuccessfulSearches          INT DEFAULT 0,
    INDEX                       (SiteId)
);

