<?PHP

#
#   FILE:  SPT--Topic.php
#
#   FUNCTIONS PROVIDED:
#       Topic->Topic($TopicId)
#           - constructor
#       Topic->TopicId()
#       Topic->ForumId()
#       Topic->CreatorId()
#       Topic->DateCreated()
#       Topic->TopicName()
#       Topic->ViewCount()
#       Topic->MessageCount()
#       Topic->Delete()
#           - methods to retrieve resource attributes
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once(dirname(__FILE__)."/../Axis--User.php");


class Topic {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function Topic($TopicId = NULL)
    {
        # locate class in database
        $this->DB =& new SPTDatabase();
        $DB =& $this->DB;
        # if ID supplied
        if ($TopicId !== NULL)
        {
            $this->TopicId = intval($TopicId);
            $DB->Query("SELECT * FROM Topics WHERE TopicId = ".$this->TopicId);

            # if row was loaded
            if ($DB->NumRowsSelected() > 0)
            {
                # set attributes to values returned by database
                $this->DBFields = $DB->FetchRow();
            }
        }
        else
        {
            # add record to database with that ID
            $DB->Query("INSERT INTO Topics (TopicId) VALUES (NULL)");
            $this->TopicId = $DB->Query("SELECT LAST_INSERT_ID()"
                    ." AS TopicId FROM Topics", "TopicId");
        }

    }

    # remove topic from database, and underlying messages
    function GetMessageList()
    {
        $Messages = array();

        $this->DB->Query("Select * from Messages where ParentId = ".
                    $this->TopicId.
                    " AND ParentType = 1 ORDER BY DatePosted DESC");

        # delete messages associated with this topic
        while ($Entry = $this->DB->FetchNextRowArray())
        {
            $Messages[$Entry["MessageId"]] = & new Message($Entry["MessageId"]);
        }
        return $Messages;
    }

    # remove topic from database, and underlying messages
    function Delete()
    {
        $this->DB->Query("Select * from Messages where ParentId = ".
                    $this->TopicId." AND ParentType = 1");

        # delete messages associated with this topic
        while ($Entry = $this->DB->FetchNextRowArray())
        {
            $Message = & new Message($Entry["MessageId"]);
            $Message->Delete();
        }

        # delete record from database
        $this->DB->Query("DELETE FROM Topics WHERE TopicId = ".$this->TopicId);
    }

    # get attribute
    function TopicId()        {  return $this->TopicId;  }
    function CreatorName()
    {
        $CreatorName =& new User($this->DB, (int)$this->CreatorId());
        return $CreatorName->Get("UserName");
    }

    function CreatorEmail()
    {
        $CreatorName =& new User($this->DB, (int)$this->CreatorId());
        return $CreatorName->Get("EMail");
    }

    # get/set attributes
    function ForumId($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ForumId", $NewValue);  }
   function CreatorId($NewValue = DB_NOVALUE) {  return $this->UpdateValue("CreatorId", $NewValue);  }
   function DateCreated($NewValue = DB_NOVALUE) {  return $this->UpdateValue("DateCreated", $NewValue);  }
   function TopicName($NewValue = DB_NOVALUE) {  return $this->UpdateValue("TopicName", $NewValue);  }
   function ViewCount($NewValue = DB_NOVALUE) {  return $this->UpdateValue("ViewCount", $NewValue);  }
   function MessageCount($NewValue = DB_NOVALUE) {  return $this->UpdateValue("MessageCount", $NewValue);  }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $TopicId;
    var $DB;
    var $DBFields;
    
    # convenience function to supply parameters to Database->UpdateValue()
    function UpdateValue($FieldName, $NewValue)
    {
        return $this->DB->UpdateValue("Topics", $FieldName, $NewValue,
                   "TopicId = '".$this->TopicId."'", $this->DBFields, TRUE);
    }
}

?>
