<?PHP
#
#   FILE:  TopicMessages.php
#
#   FUNCTIONS PROVIDED:
#       - PrintForumName()
#       - PrintForumDescription()
#       - PrintTopicName()
#       - PrintVar()
#       - CheckForModeratorOrSysAdmin()
#       - CheckForUserLoggedIn()
#       - DisplayMessages()
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

PageTitle("Topic Messages");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed
    if (count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

function PrintForumName()
{
    global $ForumName;

    print $ForumName;
}

function PrintForumDescription()
{
    global $ForumDescription;

    print $ForumDescription;
}


function PrintTopicName()
{
    global $TopicName;

    print $TopicName;
}

function PrintVar($VarName)
{
    print $VarName;
}

function CheckForModeratorOrSysAdmin()
{
    global $User, $ModeratorId;

    if (($User->Get("UserId") == $ModeratorId &&
        $User->HasPriv(PRIV_FORUMADMIN))
        || $User->HasPriv(PRIV_SYSADMIN))
        return true;
    else
        return false;
}

function CheckForUserLoggedIn()
{
    global $User;

    if ($User->IsLoggedIn() == TRUE)
        return true;
    else
        return false;
}

function DisplayMessages()
{
    global $TopicId;
    global $ForumId;
    global $PosterId;
    global $MessageCount;
    global $G_User;

    if (isset($TopicId))
    {
        $Topic = new Topic($TopicId);

        $Messages = $Topic->GetMessageList();
        $MessageCount = count($Messages);

        foreach ($Messages as $MessageId => $Message)
        {
            $Subject = $Message->Subject();
            $Body = $Message->Body();
            $DatePosted = $Message->DatePosted();
            $Poster = new SPTUser(intval($Message->PosterId()));
            $PrivList = $Poster->GetPrivList();
            $PosterId = $Message->PosterId();
            $PosterName = $Message->PosterName();
            $PosterEmail = $Message->PosterEmail();
            $EditOkay = CheckForEdit();
            $EditLink = "index.php?P=PostMessage"
                ."&amp;ForumId=".$ForumId
                ."&amp;TopicId=".$TopicId
                ."&amp;MessageId=".$MessageId;
            $DeleteLink = "index.php?P=PostMessage"
                ."&amp;ForumId=".$ForumId
                ."&amp;TopicId=".$TopicId
                ."&amp;MessageId=".$MessageId;

            # see if this user has permission to remove posting privileges
            if (CheckForRemovePostPrivilege()
                && ($Message->PosterId() != $G_User->Id())
                && in_array(strval(PRIV_POSTTOFORUMS), $PrivList))
            {
                $RemovePostPrivLink = "index.php?P=UpdateTopic"
                    ."&amp;ForumId=".$ForumId
                    ."&amp;TopicId=".$TopicId
                    ."&amp;MessageId=".$MessageId
                    ."&amp;Submit=".urlencode("Remove Post Privilege");
            }

            else
            {
                $RemovePostPrivLink = NULL;
            }

            PrintForumMessage($Subject, $Body, $DatePosted, $PosterName,
                              $PosterEmail, $EditOkay, $EditLink, $DeleteLink,
                              $RemovePostPrivLink, FALSE, NULL);
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# update the viewcount every time page is loaded
function UpdateViewCount()
{
    global $TopicId;

    if (isset($TopicId))
    {
        $Topic = new Topic($TopicId);
        $ViewCount = $Topic->ViewCount();
        $Topic->ViewCount($ViewCount + 1);
    }
}

# see if user has permission to edit the message
function CheckForEdit()
{
    global $User, $ModeratorId, $PosterId;

    if ($User->Get("UserId") == $ModeratorId ||
        ($User->Get("UserId") == $PosterId &&
        $User->HasPriv(PRIV_POSTTOFORUMS)) ||
        $User->HasPriv(PRIV_FORUMADMIN))
        return true;
    else
        return false;
}

# check if user can remove post privilege
function CheckForRemovePostPrivilege()
{
    global $User, $ModeratorId;

    if ($User->HasPriv(PRIV_FORUMADMIN) &&
        $User->HasPriv(PRIV_USERADMIN))
        return true;
    else
        return false;
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $ForumDescription;
global $ForumId;
global $ForumName;
global $MessageCount;
global $ModeratorId;
global $PosterId;
global $TopicId;
global $TopicName;
global $VarName;

# other global variables
global $Topic;
global $Forum;

if (isset($_GET["TI"]))
{
    $TopicId = intval($_GET["TI"]);
    $Topic = new Topic($TopicId);
    $ForumId = $Topic->ForumId();
}
else
{
    if (isset($_GET["TopicId"]))
    {
        $TopicId = intval($_GET["TopicId"]);
    }
    elseif ($Session->IsRegistered("TopicId"))
    {
        $SessionFlag = TRUE;
        $TopicId = $Session->Get("TopicId");
    }
    
    if (isset($_GET["ForumId"]))
    {
        $ForumId = intval($_GET["ForumId"]);
    }
    else
    {
        $SessionFlag = TRUE;
        $ForumId = $Session->Get("ForumId");
    }
}

# redirect to this page to use GET parameters since the session ones won't
# exist if someone refreshes or clicks a link and clicks the back button
if (isset($SessionFlag))
{
    $Page = "index.php?P=TopicMessages&ForumId=".$ForumId;

    if (isset($TopicId))
    {
        $Page .= "&TopicId=".$TopicId;
    }

    $AF->SetJumpToPage($Page);
    return;
}

if (isset($TopicId) && isset($ForumId))
{
    $Topic = new Topic($TopicId);
    $TopicName = $Topic->TopicName();

    $Forum = new Forum($ForumId);
    $ForumName = $Forum->ForumName();
    $ForumDescription = $Forum->ForumDescription();
    $ModeratorId = $Forum->ModeratorId();

    $ErrorMessages = $Session->Get("ErrorMessages");

    UpdateViewCount();
}

