<?PHP
# Page loading begins here:

global $AF;

$AF->SuppressHTMLOutput();

header('Content-type: application/vnd.google-earth.kml+xml');

# Check to see that we've got all the required data
if (isset($_GET["PP"]) && isset($_GET["DP"]) )
{
    # Pull out the callback, user spec'd paramters, and try to load
    # the callback.
    $Row = $DB->Query("SELECT Payload,Params FROM GoogleMapsCallbacks "
                      ."WHERE Id='".addslashes($_GET["PP"])."'");
    $Row = $DB->FetchRow();
    $PPCallback = unserialize($Row["Payload"]);
    $PPParams     = unserialize($Row["Params"]);


    $DB->Query("SELECT Payload, Params FROM GoogleMapsCallbacks "
               ."WHERE Id='".addslashes($_GET["DP"])."'");
    $Row = $DB->FetchRow();
    $DPCallback = unserialize($Row["Payload"]);
    $DPParams   = unserialize($Row["Params"]);

    if ($AF->LoadFunction($PPCallback) &&
        $AF->LoadFunction($DPCallback) )
    {
        # Call the supplied DP, expecting an Array.
        $Points = call_user_func_array( $PPCallback, array($PPParams));


        # Enumerate the different marker types that we're using:
        $MarkerTypes = array();
        foreach ($Points as $Point)
        {
            $BgColor = str_replace('#','',$Point[3]);
            $Label   = htmlentities($Point[4]);
            $FgColor = str_replace('#','',$Point[5]);

            $MarkerTypes[$Label.$BgColor.$FgColor] =
                "http://chart.apis.google.com/chart"
                ."?chst=d_map_pin_letter_withshadow"
                ."&chld=".$Label."|".$BgColor."|".$FgColor;
        }

        # Generate KML:
        print(
            '<?xml version="1.0" encoding="UTF-8"?>'."\n"
            .'<kml xmlns="http://www.opengis.net/kml/2.2" '."\n"
            .'xmlns:gx="http://www.google.com/kml/ext/2.2">'."\n"
            ."<Document>\n");

        # Style elements to define markers:
        foreach ($MarkerTypes as $Key => $Value)
        {
            print(
                '<Style id="'.$Key.'">'
                .'<IconStyle>'
                .'<Icon><href>'.htmlentities($Value).'</href></Icon>'
                .'</IconStyle>'
                .'</Style>');
        }

        # Point elements:
        foreach ($Points as $Point)
        {
            $Lat = $Point[0];
            $Lon = $Point[1];
            $Id  = $Point[2];
            $BgColor = $Point[3];
            $Label   = $Point[4];
            $FgColor = $Point[5];

            ob_start();
            call_user_func_array($DPCallback,
                                 array(
                                     "Id" => $Id,
                                     "Params" => $DPParams ));
            $Desc = ob_get_contents();
            ob_end_clean();

            print(
                '<Placemark id="'.htmlentities($Id).'">'
                .'<name></name>'
                .'<styleUrl>#'.$Label.$BgColor.$FgColor.'</styleUrl>'
                .'<Point><coordinates>'.$Lat.','.$Lon.'</coordinates></Point>'
                .'<description><![CDATA['.$Desc.']]></description>'
                .'</Placemark>');
        }

        print("</Document></kml>");
    }
}

?>
