<?php
#
#   FILE:  SPT--AssignControlledName.php
#
#   FUNCTIONS PROVIDED:
#       DisplayAddedControlledNames()
#           - displays newly added ControlledNames, updates intersection
#             tables, and updates DateLastModified for affectd Resources 
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# process selected controlled names
function ProcessSelectedControlledNames()
{
    global $ResourceId;

    $Schema = new MetadataSchema();

    reset($_POST);
    while (list($Var, $Value) = each ($_POST))
    {
        if (ereg("cn_([0-9]+)", $Var, $Regs) )
        {
            $Value = trim($Value);
            if ($Value != "")
            {
                $ControlledName = $Value;
                continue;
            }
        }
        if (ereg("cnid_([0-9]+)", $Var, $Regs) )
        {
            $Value = trim($Value);
            if ($Value != "")
            {
                $ControlledNameId = $Value;
                $CN = new ControlledName($ControlledNameId);
                $Field = $Schema->GetField($CN->FieldId());
                $Resource = new Resource($ResourceId);
                $Resource->Set($Field->Name(), $ControlledNameId);
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ResourceId;

if (!CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN)) {  return;  }

# get currently edited resource
$RFactory = new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

ProcessSelectedControlledNames();

# return to the DB Entry page
$Link = "index.php?P=DBEntry&amp;ResourceId=".$ResourceId;
$AF->SetJumpToPage($Link);
?>
