<?PHP
#
#   FILE:  Preferences.php
#
#   FUNCTIONS PROVIDED:
#       PrintErrorMessages()
#           - print any outstanding error messages from form processing
#       PrintActiveUIOptionList()
#           - print option list containing user interfaces, current UI selected
#       PrintSearchResultsPerPageOptionList()
#           - print option list containing records per page, current selected
#       PrintCurrentRealName()
#       PrintCurrentEMail()
#       PrintCurrentWebSite()
#       PrintCurrentAddressLineOne()
#       PrintCurrentAddressLineTwo()
#       PrintCurrentCity()
#       PrintCurrentState()
#       PrintCurrentZipCode()
#       PrintCurrentCountry()
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintSuccessMessages()
{
    global $SuccessMessages;

    # if messages were passed from PreferencesComplete
    if (is_array($SuccessMessages))
    {
        foreach ($SuccessMessages as $Message)
        {
            PrintSuccessMessage($Message);
        }
    }
}

function PrintErrorMessages()
{
    global $ErrorMessages;
    global $SuccessMessages;

    # if error messages were passed from PreferencesComplete
    if (is_array($ErrorMessages))
    {
        if (function_exists("PrintErrorMessage"))
        {
            foreach ($ErrorMessages as $Message)
            {
                PrintErrorMessage($Message);
            }
        }

        # backwards compatibility
        else
        {
            $AllMessages = (is_array($SuccessMessages))
                ? array_merge($ErrorMessages, $SuccessMessages) : $ErrorMessages;

            # print error messages
            print("<ul>\n");

            foreach ($AllMessages as $Message)
            {
                printf("<li>%s</li>\n", $Message);
            }

            print("</ul>\n");
        }
    }
}

function PrintActiveUIOptionList()
{
    global $User;

    # print option list for UI
    print(GetActiveUIOptionList($User->Get("ActiveUI")));
}

function PrintSearchResultsPerPageOptionList()
{
    global $User, $SysConfig;

    $Selected = NULL;

    if ($User->IsLoggedIn())
    {
        $Selected = $User->Get("RecordsPerPage");
    }

    if (is_null($Selected))
    {
        $Selected = $SysConfig->DefaultRecordsPerPage();
    }

    foreach (array(5, 10, 20, 30, 50, 100) as $Option)
    {
        print "<option";

        if ($Option == $Selected)
        {
            print " selected=\"selected\"";
        }

        print ">".$Option."</option>";
    }
}

function PrintCurrentRealName()
{
    global $User;
    print($User->Get("RealName"));
}

function PrintCurrentEMail()
{
    global $User;
    print($User->Get("EMail"));
}

function PrintCurrentWebSite()
{
    global $User;
    print($User->Get("WebSite"));
}

function PrintCurrentAddressLineOne()
{
    global $User;
    print($User->Get("AddressLineOne"));
}

function PrintCurrentAddressLineTwo()
{
    global $User;
    print($User->Get("AddressLineTwo"));
}

function PrintCurrentCity()
{
    global $User;
    print($User->Get("City"));
}

function PrintCurrentState()
{
    global $User;
    print($User->Get("State"));
}

function PrintCurrentZipCode()
{
    global $User;
    print($User->Get("ZipCode"));
}

function PrintCurrentCountry()
{
    global $User;
    print($User->Get("Country"));
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $SuccessMessages;

PageTitle("User Preferences");

# go to the homepage if not logged in
if (!$User->IsLoggedIn())
{
    $AF->SetJumpToPage("Home");
}

# get error messages saved in the session
if ($Session->IsRegistered("ErrorMessages"))
{
    $ErrorMessages = $Session->Get("ErrorMessages");
}

if ($Session->IsRegistered("SuccessMessages"))
{
    $SuccessMessages = $Session->Get("SuccessMessages");
}
