<?PHP
#
#   FILE:  ConfirmRemoveUser.php
#
#   FUNCTIONS PROVIDED:
#       PrintUserName()
#       - print out topic name
#
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to return true if users have been selected for removal
function RemoveUsersExist()
{
    global $UserRemoveArray;

    return count($UserRemoveArray);
}

function PrintUserList()
{
    global $Session, $UserRemoveArray;

    $DB = new SPTDatabase();

    foreach ($UserRemoveArray as $UserId)
    {
        $RemoveUser = new User($DB, intval($UserId));
        print $RemoveUser->Get("UserName")."<br>";
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $UserRemoveArray;

PageTitle("Confirm Remove User");

# check if current user is authorized
CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN);

$UserRemoveArray = $Session->Get("UserRemoveArray");

$Session->PassVariable("OkayToRemove", 1);
$Session->PassVariable("UserRemoveArray", $UserRemoveArray);
