<?PHP

#
#   FILE:  ControlledNameFactory.php
#
#   Part of the Collection Workflow Integration System
#   Copyright 2011 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

/**
* Factory for manipulating ControlledName objects.
*/
class ControlledNameFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    function ControlledNameFactory($FieldId = NULL)
    {
        # set up item factory base class
        $this->ItemFactory("ControlledName", "ControlledNames", "ControlledNameId", "ControlledName", $FieldId);
    }

    /**
    * Determine how many resources have controlled names (associated with this
    *   metadata field) assigned to them.
    * @return Count of resources with names assigned.
    **/
    function GetUsageCount()
    {
        return $this->DB->Query("SELECT COUNT(DISTINCT RNI.ResourceId) AS ResourceCount"
                ." FROM ResourceNameInts RNI, ControlledNames CN"
                ." WHERE CN.FieldId = ".intval($this->FieldId)
                ." AND RNI.ControlledNameId = CN.ControlledNameId"
                ." AND RNI.ResourceId >= 0",
                "ResourceCount");
    }
    

    # ---- PRIVATE INTERFACE -------------------------------------------------

}


?>
