<?PHP
#
#   FILE:  AddForum.php
#
#   FUNCTIONS PROVIDED:
#       DisplayForums()
#           - Display list of forums
#
#   FUNCTIONS EXPECTED:
#
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintForumHeading()
{
    global $Session;

    $Edit = $Session->Get("Edit");

    if ($Edit > 0)
        print "Edit Forum";
    else
        print "Add New Forum";
}

function PrintForumButton()
{
    global $Session;

    $Edit = $Session->Get("Edit");

    if ($Edit > 0)
        print "Update Forum";
    else
        print "Add New Forum";
}

function PrintForumName()
{
    global $Session;

    print GetHtmlEscapedString($Session->Get("F_ForumName"));
}

function PrintForumDescription()
{
    global $Session;

    print GetHtmlEscapedString($Session->Get("F_ForumDescription"));
}

# display list of forums from a query
function DisplayForums($FieldName)
{
    global $Session;
    $DB = new Database();

    $F_ForumId = $Session->Get("F_ForumId");

    $Query = "Select * from Forums Order By ForumName";
    $DB->Query($Query);

    $Selected=0;
    $Items = array();
    while ($Entry = $DB->FetchRow())
    {
        $Forum = new Forum($Entry["ForumId"]);
        if ($Selected == 0 && is_null($F_ForumId))
            $F_ForumId = $Entry["ForumId"];

        $Items[$Entry["ForumId"]] = $Forum->ForumName();
        $Selected++;
    }
    PrintOptionList($FieldName, $Items, $F_ForumId, 0, 4, NULL, false);
}

# display a list of users
function DisplayUserList($Moderator)
{
    global $Session;

    $Selected = NULL;
    $F_ForumId = $Session->Get("F_ForumId");

    $UFactory = new UserFactory($Session);
    $Items = $UFactory->GetUsersWithPrivileges(PRIV_FORUMADMIN);

    # display selected moderator
    if (isset($F_ForumId))
    {
        $Forum = new Forum($F_ForumId);
        $Selected = $Forum->ModeratorId();
    }
    if (count($Items))
    {
        PrintOptionList($Moderator, $Items, $Selected, NULL, 1, NULL, false);
    }
    else
    {
        print("(NO USERS AVAILABLE WITH FORUM ADMIN PRIVILEGES!)");
    }
}

# print out any error messages
function PrintErrorMessages()
{
    global $Session;

    $ErrorMessages = $Session->Get("ErrorMessages");

    # if error messages were passed
    if (isset($ErrorMessages) && is_array($ErrorMessages) &&
        count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

function GetForums()
{
    $Database = new Database();

    $Query = "SELECT * FROM Forums ORDER BY ForumName";
    $Database->Query($Query);

    $Forums = array();

    while (FALSE !== ($Row = $Database->FetchRow()))
    {
        $ForumId = $Row["ForumId"];
        $Forums[$ForumId] = new Forum($ForumId);
    }

    return $Forums;
}

# get the number of forums
function GetForumCount()
{
    $Database = new Database();

    $Query = "SELECT * FROM Forums ORDER BY ForumName";
    $Database->Query($Query);

    $Count = $Database->NumRowsSelected();

    return $Count;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

PageTitle("Add/Remove Forums");

CheckAuthorization(PRIV_SYSADMIN, PRIV_FORUMADMIN);

include_once("lib/AxisPHP/Axis--StandardLibrary.php");
