<?PHP

#
#   FILE:  DBOrderFields.php
#
#   FUNCTIONS PROVIDED:
#       PrintOrderedDisplayFields()
#           - Prints option elements for Enabled and Viewable fields in
#            Display order. Calls PrintDisplayFieldName()
#       PrintOrderedEditingFields()
#           - Prints option elements for Enabled and Viewable fields in
#            Editing order. Calls PrintEditingFieldName()
#       PrintOrderedLabel()
#           - Prints label for field
#       PrintOrderedFieldId()
#           - Prints Id of field
#
#   FUNCTIONS EXPECTED:
#       PrintDisplayFieldName()
#           - Print option field in display order
#       PrintEditingFieldName()
#           - Print option field in editing order
#
#   FORM FIELDS EXPECTED:
#       None
#
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# PrintOrderedDisplayFields prints fields names in Display order.
function PrintOrderedDisplayFields()
{
    PrintOrderedFields( MetadataSchema::MDFORDER_DISPLAY );
}

# PrintOrderedEditingFields prints fields names in Editing order.
function PrintOrderedEditingFields()
{
    PrintOrderedFields( MetadataSchema::MDFORDER_EDITING );
}

# function to print field name
function PrintLabel()
{
    global $Label;

    print $Label;
}

# function to print field Id
function PrintFieldId()
{
    global $FieldId;

    print $FieldId;
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function PrintOrderedFields( $Order )
{
    global $Label;
    global $FieldId;

    # Initialize the schema object
    $Schema = new MetadataSchema();

    # Get fields, order indicated by $Order
    $Fields = $Schema->GetFields(NULL, $Order, FALSE);

    # Grab the fields that are enabled.
    # Fields for Display must be Viewable
    foreach ($Fields as $Field)
    {
        if ($Field->Enabled())
        {
            $Labels[] = $Field->Name();
        }
    }

    # Get the relevant information from the Field object and display it
    foreach ($Labels as $Label)
    {
        $Field = $Schema->GetFieldByName($Label);
        $FieldId = $Field->Id();

        #Call to function in html page
        if ( $Order == MetadataSchema::MDFORDER_DISPLAY )
        {
            PrintDisplayFieldName();
        }
        else
        {
            PrintEditingFieldName();
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $FieldId;
global $Label;

PageTitle("Metadata Field Ordering");

CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);
