<?PHP
#
#   FILE:  NewSavedSearch.php
#
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# (for PrintOptionList())
include_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if (!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

function PrintFrequencyOptionList()
{
    global $User;
    if ($User->HasPriv(PRIV_RESOURCEADMIN))
    {
        $FreqList = SavedSearch::GetSearchFrequencyList();
    }
    else
    {
        $FreqList = SavedSearch::GetSearchFrequencyList(SavedSearch::SEARCHFREQ_HOURLY);
    }
    PrintOptionList("F_SearchFreq", $FreqList, SavedSearch::SEARCHFREQ_NEVER);
}

function PrintCriteria()
{
    global $SearchGroups;
    $CriteriaText = SavedSearch::TranslateSearchGroupsToTextDescription(
            $SearchGroups);
    print $CriteriaText;
}

function PrintFormUrl()
{
    global $SearchGroups;
    print("index.php?P=SavedSearch&amp;"
          .SavedSearch::TranslateSearchGroupsToUrlParameters($SearchGroups));
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $SearchGroups;

PageTitle("Save Search");

$SearchGroups = SavedSearch::TranslateUrlParametersToSearchGroups($_GET);
