<?PHP

class OpenIdServer extends Plugin
{
    function Register()
    {
        $this->Name = "OpenID Server";
        $this->Version = "1.0.2";
        $this->Description =
            "Allows other sites to authenticate against the users registered on "
            ."this site using "
            ."<a href=\"http://openid.net\" target=\"_blank\">OpenID</a>, ";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
            "CWISCore" => "1.9.0"
            );
    }

    function Install()
    {
        $this->Upgrade("X-NO-VERSION-X");
    }

    function Upgrade($PreviousVersion)
    {
        $DB = new Database();

        switch ($PreviousVersion)
        {

        case "1.0.0":
        case "1.0.1":
            $DB->Query("DROP TABLE OidTrustMap");
        case "X-NO-VERSION-X":
            $DB->Query("CREATE TABLE OpenIdServer_TrustMap ("
                       ."UserName VARCHAR(32), Site VARCHAR(32), "
                       ."PRIMARY KEY (UserName, Site))");
        default:
        }
    }

}

?>
