<?PHP
#
#   FILE:  DownloadFile.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# if file ID was supplied
if (isset($_GET["Id"]))
{
    $FileId = intval($_GET["Id"]);
    $File = new File($FileId);

    # if file info was loaded successfully
    if ($File->Status() == File::FILESTAT_OK)
    {
        $Schema = new MetadataSchema();
        $Field = $Schema->GetField($File->FieldId());
        $Resource = new Resource($File->ResourceId());

        # if user can view file
        if ($Resource->UserCanViewField($User, $Field))
        {
            $Filepath = $File->GetNameOfStoredFile();
            $Filename = addslashes($File->Name());
            $Mimetype = $File->GetMimeType();

            # set headers to download file
            header("Content-disposition: attachment; filename=\"".$Filename."\"");
            header("Content-type: ".$Mimetype);

            # send file to user
            readfile($Filepath);

            $AF->SuppressHTMLOutput();
        }

        else
        {
            CheckAuthorization(-1);
        }
    }
}
