<?PHP
#
#   FILE:  EditControlledNameLists.php
#
#   FUNCTIONS PROVIDED:
#       DisplayControlledNameLists()
#           - Display list of controlled names from a query
#
#   FUNCTIONS EXPECTED:
#       DisplayControlledNameSelection()
#           - display a controlled name for editing
#       DisplayAddButtons()
#           - display Add, Remove, and Cancel buttons
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

include_once("lib/AxisPHP/Axis--StandardLibrary.php");  # (for PrintOptionList())

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# display the field name
function PrintDisplayString()
{
    global $FieldName;

    print $FieldName;
}

# function to print the index value
function PrintIndex()
{
    global $Index;

    print $Index;
}

# functon to print the ControlledName
function PrintControlledName()
{
    global $ControlledName;

    print GetHtmlEscapedString($ControlledName);
}

# function to print the ControlledNameId
function PrintControlledNameId()
{
    global $ControlledNameId;

    print $ControlledNameId;
}

# returns true if field uses qualifiers
function FieldUsesQualifiers()
{
    global $DefaultField;

    if (is_object($DefaultField))
        return $DefaultField->UsesQualifiers();
    else
        return false;
}

# function to determine if field has itemlevelqualifiers or not
function FieldHasItemLevelQualifiers()
{
    global $DefaultField;

    if (is_object($DefaultField))
        return $DefaultField->HasItemLevelQualifiers();
    else
        return false;
}

# print Qualifier option list
function PrintQualifierOrList()
{
    global $QualifierId;
    global $Index;
    global $FieldId;

    $Schema = new MetadataSchema();
    $Field = $Schema->GetField($FieldId);

    if (FieldHasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        PrintOptionList("qid_".$Index, $Items, $QualifierId,
            0, 1, NULL, false);
    }
    else
    {
        $Qualifier = new Qualifier($Field->DefaultQualifier());
        if (is_object($Qualifier))
            print GetHtmlEscapedString($Qualifier->Name());
    }
}

# function to print the DefaultString
function PrintDefaultString()
{
    global $DefaultString;

    print $DefaultString;
}

# function to return if any enabled option list fields exist
function OptionListsExist()
{
    $Schema = new MetadataSchema();
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_OPTION);
    $Flag = FALSE;

    foreach ($Fields as $Field)
    {
        if ($Field->Enabled())
        {
            $Flag = TRUE;
            break;
        }
    }
    return $Flag;
}

# print out any error messages
function PrintErrorMessages()
{
    global $Session;

    $ErrorMessages = $Session->Get("ErrorMessages");

    # if error messages were passed
    if (count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

# display controlled name lists for editing
function DisplayControlledNameLists()
{
    global $Session;
    global $FieldName;
    global $FieldId;
    global $ControlledName;
    global $ControlledNameId;
    global $QualifierId;
    global $DefaultString;
    global $DefaultField;
    global $Index;

    $Items = array();

    $DB = new SPTDatabase();
    $Schema = new MetadataSchema();

    $FieldName = $Session->Get("FieldName");

    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_OPTION);

    foreach ($Fields as $Field)
    {
        if ($Field->Enabled())
        {
            if (empty($FieldName))
                $FieldName = $Field->Name();
            $Items[$Field->Name()] = $Field->Name();

            # determine default value for selected option field
            $DefaultValue = $Field->DefaultValue();
            if (isset($DefaultValue) &&
                $Field->Name() == $FieldName)
            {
                $DefaultField = $Field;
                $Default = $Field->DefaultValue();
            }
        }
    }

    $Field = $Schema->GetFieldByName($FieldName);
    $FieldId = $Field->Id();
    $DefaultField = $Field;

    PrintOptionList("Submit", $Items, $FieldName, 1, 1, NULL, false);
    PrintBegin();
    PrintHeader();

    $Session->PassVariable("FieldId", $FieldId);
    $Session->PassVariable("FieldName", $FieldName);

    $query = "Select * from ControlledNames where FieldId=".
        $FieldId." ORDER BY ControlledName";

    $DB->Query($query);

    $Index = 0;
    while ($Index < $DB->NumRowsSelected())
    {
        $Result = $DB->FetchRow();
        $ControlledName = $Result["ControlledName"];
        $ControlledNameId = $Result["ControlledNameId"];
        $CN = new ControlledName($ControlledNameId);
        $InUseCount = $CN->InUse();

        $QualifierId = $Result["QualifierId"];

        # display number of resources using this option
        if ($InUseCount > 0)
            $DefaultString = "(This value in use by $InUseCount Resources)";
        else
            $DefaultString = "(This value is not currently in use)";

        # display selected default
        if (isset($Default) && ($ControlledNameId == $Default))
            $DefaultString .= " - <b>Default</b> ";

        DisplayControlledNameSelection();
        if ($Field->UsesQualifiers())
            DisplayQualifier();
        $Index++;
    }
    # set index to NULL for qualifier field name for new values
    $Index = NULL;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ControlledName;
global $ControlledNameId;
global $DefaultField;
global $DefaultString;
global $FieldId;
global $FieldName;
global $Index;
global $QualifierId;

if (!CheckAuthorization(PRIV_NAMEADMIN)) {  return;  }

PageTitle("Edit Controlled Attribute Lists");
