<?PHP

#
#   Axis--Image--Test.php
#   Test scaffolding for the AxisPHP Image object.
#
#   Copyright 2002-2003 Axis Data
#   This code is free software that can be used or redistributed under the
#   terms of Version 2 of the GNU General Public License, as published by the
#   Free Software Foundation (http://www.fsf.org).
#
#   Author:  Edward Almasy (ealmasy@axisdata.com)
#
#   Part of the AxisPHP library v1.2.5
#   For more information see http://www.axisdata.com/AxisPHP/
#

require_once("Axis--Image.php");

$Img = new Image("TestImage1.jpg");
printf("Image Manipulation Method: %s<br>\n", $Img->ImageManipulationMethod());

?>Original #1:<br><img src="TestImage1.jpg"><br><br><br><?PHP

$Img = new Image("TestImage1.jpg");
$Img->ScaleTo(100, 100);
$Img->SaveAs("TestImage--TEMP1.jpg");
?>JPEG scaled to 100w by 100h:<br><img src="TestImage--TEMP1.jpg"><br><br><br><?PHP

$Img = new Image("TestImage1.jpg");
$Img->ScaleTo(100, 100, TRUE);
$Img->SaveAs("TestImage--TEMP4.jpg");
?>JPEG scaled to 100w by 100h with aspect ration maintained:<br><img src="TestImage--TEMP4.jpg"><br><br><br><?PHP

$Img = new Image("TestImage1.jpg");
$Img->CropTo(300, 200, 50, 300);
$Img->SaveAs("TestImage--TEMP2.jpg");
?>JPEG cropped to 300w by 200h:<br><img src="TestImage--TEMP2.jpg"><br><br><br><?PHP

$Img = new Image("TestImage1.jpg");
$Img->CropTo(300, 200, 50, 300);
$Img->SaveAs("TestImage--TEMP2.jpg");
?>JPEG cropped to 300w by 200h:<br><img src="TestImage--TEMP2.jpg"><br><br><br><?PHP

if (imagetypes() & IMG_GIF)
{
    $Img = new Image("TestImage1.jpg");
    $Img->ScaleTo(50, 300);
    $Img->SaveAs("TestImage--TEMP3.gif");
    ?>GIF scaled to 50w by 300h:<br><img src="TestImage--TEMP3.gif"><br><br><br><?PHP
}
else
{
    print("GIF image output not supported on this server<br><br><br>\n");
}

?>Original #2:<br><img src="TestImage2.jpg"><br><br><br><?PHP

$Img = new Image("TestImage2.jpg");
$Img->ScaleTo(100, 100, TRUE);
$Img->SaveAs("TestImage--TEMP5.jpg");
?>JPEG scaled to 100w by 100h with aspect ration maintained:<br><img src="TestImage--TEMP5.jpg"><br><br><br><?PHP

$Img = new Image("TestImage2.jpg");
$Img->ScaleTo(100, 200, TRUE);
$Img->SaveAs("TestImage--TEMP6.jpg");
?>JPEG scaled to 100w by 200h with aspect ration maintained:<br><img src="TestImage--TEMP6.jpg"><br><br><br><?PHP

$Img = new Image("TestImage2.jpg");
$Img->ScaleTo(200, 100, TRUE);
$Img->SaveAs("TestImage--TEMP7.jpg");
?>JPEG scaled to 200w by 100h with aspect ration maintained:<br><img src="TestImage--TEMP7.jpg"><br><br><br><?PHP

?>

