<?PHP
#
#   FILE:  ConvertTypeTables.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

function ConvertControlledNameTypes()
{
    global $DB, $Schema, $Debug;

    # get list of ControlledName and Option fields
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_CONTROLLEDNAME | MetadataSchema::MDFTYPE_OPTION);

    # convert each one
    foreach ($Fields as $Field)
    {

        if ($Debug)
            echo "query=Select ControlledNameTypeId from ".
                "ControlledNameTypes where ControlledNameTypeName = \"".
                $Field->Name()."\"<br>";

        $TypeId = $DB->Query("Select ControlledNameTypeId from ".
            "ControlledNameTypes where ControlledNameTypeName = \"".
            $Field->Name()."\"", "ControlledNameTypeId");

        if ($Debug)
            echo "query=UPDATE ControlledNames SET ControlledNameTypeId = ".
                $Field->Id()." WHERE ControlledNameTypeId = $TypeId<br>";

        # this shouldn't happen unless the Type table is out of synch
        if (isset($TypeId))
            $DB->Query("UPDATE ControlledNames SET ControlledNameTypeId = ".
                $Field->Id()." WHERE ControlledNameTypeId = $TypeId");
    }

    # change the field in ControlledNames
    $DB->Query("ALTER TABLE ControlledNames CHANGE COLUMN ".
                "ControlledNameTypeId FieldId INT");


    # should now be safe to drop the obsolete table
    $DB->Query("DROP TABLE ControlledNameTypes");
}

function ConvertClassificationTypes()
{
    global $DB, $Schema, $Session, $Debug;

    $UFactory = new UserFactory($Session);

    # get list of tree fields
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_TREE);

    # convert each one
    foreach ($Fields as $Field)
    {

        if ($Debug)
            echo "query=Select ClassificationTypeId from ".
            "ClassificationTypes where ClassificationTypeName = \"".
            $Field->Name()."\"<br>";

        $TypeId = $DB->Query("Select ClassificationTypeId from ".
            "ClassificationTypes where ClassificationTypeName = \"".
            $Field->Name()."\"", "ClassificationTypeId");

        if ($Debug)
            echo "UPDATE Classifications SET ClassificationTypeId = ".
                $Field->Id()." WHERE ClassificationTypeId = $TypeId<br>";

        # TypeId should be set unless type table is out of sync
        if (isset($TypeId))
            $DB->Query("UPDATE Classifications SET ClassificationTypeId = ".
                $Field->Id()." WHERE ClassificationTypeId = $TypeId");
    }

    # update the field in the classifications table
    $DB->Query("ALTER TABLE Classifications CHANGE COLUMN ".
                "ClassificationTypeId FieldId INT");

    # now convert the default browsing field
    $FieldId = $DB->Query(
        "Select ClassificationTypeId from SystemConfiguration",
        "ClassificationTypeId");

    $FieldName = $DB->Query(
        "Select ClassificationTypeName from ClassificationTypes ".
        "WHERE ClassificationTypeId = $FieldId", "ClassificationTypeName");

    $Field = $Schema->GetFieldByName($FieldName);

    # store field id for browsing field id
    if (is_object($Field))
    {
        $DB->Query("Update SystemConfiguration Set ClassificationTypeId = ".
                    $Field->Id());
    }

    # rename the field to something more meaningful
    $DB->Query("ALTER TABLE SystemConfiguration CHANGE COLUMN ".
                "ClassificationTypeId BrowsingFieldId INT");

    # convert the list of users to new browsing field id
    $UserArray = $UFactory->GetMatchingUsers(".*.");
    foreach ($UserArray as $UserId => $FoundUserArray)
    {
        $FieldId = $FoundUserArray["ClassificationTypeId"];

        if ($Debug)
        {
            echo "UserId = $UserId, FieldId = $FieldId<br>";
        }

        # only process if this has been set
        if ($FieldId > 0)
        {
            $FieldName = $DB->Query(
                "Select ClassificationTypeName from ClassificationTypes ".
            "WHERE ClassificationTypeId = $FieldId", "ClassificationTypeName");

            if ($Debug)
                echo "FieldName=$FieldName<br>";

            $Field = $Schema->GetFieldByName($FieldName);

            # now update the browsing field id to found medatafield id
            if (is_object($Field))
            {
                $UserToEdit = new User($DB,
                                intval($FoundUserArray["UserId"]));
                $UserToEdit->Set("ClassificationTypeId", $Field->Id());
            }
        }
    }

    # rename the field to something more meaningful
    $DB->Query("ALTER TABLE APUsers CHANGE COLUMN ".
                "ClassificationTypeId BrowsingFieldId INT");

    # should now be safe to drop the obsolete table
    $DB->Query("DROP TABLE ClassificationTypes");
}

# non-standard global variables
global $Debug;
global $Schema;

$Schema = new MetadataSchema();
$DB = new SPTDatabase();

ConvertControlledNameTypes();
ConvertClassificationTypes();
