<?PHP
#
#   FILE:  DBPopulateTree.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# if F_FieldType is -1, then came here from DBEditor screen

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if (!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

function PrintFieldName()
{
    global $F_FieldId, $Schema;

    # get the field
    $Field = $Schema->GetField($F_FieldId);
    $FieldName = $Field->GetDisplayName();

    if (isset($FieldName))
        print $FieldName;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $F_FieldId;
global $Schema;

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

$Schema = new MetadataSchema();
$F_FieldId = $Schema->GetCurrentEditedItemId();
