<?PHP
#
#   FILE:  EditRSSExportComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu
#

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

$F_EntriesToPublish = $_POST["F_EntriesToPublish"];
$F_NotifyBrowser = $_POST['F_NotifyBrowser'];
$F_ChannelTitle = $_POST["F_ChannelTitle"];
$F_ChannelDescription = $_POST["F_ChannelDescription"];
$F_ImageUrl = $_POST["F_ImageUrl"];
$F_ImageHeight = $_POST["F_ImageHeight"];
$F_ImageWidth = $_POST["F_ImageWidth"];
$F_ImageDescription = $_POST["F_ImageDescription"];
$F_Language = $_POST["F_Language"];
$F_Copyright = $_POST["F_Copyright"];
$F_ManagingEditor = $_POST["F_ManagingEditor"];
$F_Webmaster = $_POST["F_Webmaster"];
$F_PicsRating = $_POST["F_PicsRating"];

$ErrorMessages = new ErrorList();

# the title and description are required
if (strlen($F_ChannelTitle) < 1)
{
    $ErrorMessages->AddMessage("Channel Title is required");
}
if (strlen($F_ChannelDescription) < 1)
{
    $ErrorMessages->AddMessage("Channel Description is required");
}

# make sure image height/width parameters are legal
if ($F_ImageHeight > 400 || $F_ImageHeight < 1)
{
    $ErrorMessages->AddMessage("Image Height must be <= 400 and > 1");
}
if ($F_ImageWidth > 144 || $F_ImageWidth < 1)
{
    $ErrorMessages->AddMessage("Image Width must be <= 144 and > 1");
}

if ($ErrorMessages->HasErrors())
{
    $Session->PassVariable("ErrorMessages");
    $AF->SetJumpToPage("EditRSSExport");
    return;
}

# if save changes was requested
if ($_POST["Submit"] != "Cancel")
{
    $DB = new Database();

    $Query = "UPDATE RSSConfiguration SET
        EntriesToPublish = '".addslashes($F_EntriesToPublish)."',
        NotifyBrowser = '".addslashes($F_NotifyBrowser)."',
        ChannelTitle = '".addslashes($F_ChannelTitle)."',
        ChannelDescription = '".addslashes($F_ChannelDescription)."',
        ImageUrl = '".addslashes($F_ImageUrl)."',
        ImageHeight = '".addslashes($F_ImageHeight)."',
        ImageWidth = '".addslashes($F_ImageWidth)."',
        ImageDescription = '".addslashes($F_ImageDescription)."',
        Language = '".addslashes($F_Language)."',
        Copyright = '".addslashes($F_Copyright)."',
        ManagingEditor = '".addslashes($F_ManagingEditor)."',
        Webmaster = '".addslashes($F_Webmaster)."',
        PicsRating = '".addslashes($F_PicsRating)."'";

    $DB->Query($Query);
}

# go to sys admin page
$AF->SetJumpToPage("SysAdmin");
