<?PHP
#
#   FILE:  EditSysConfig.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# functions to return sys config info (for insertion into forms)
function PrintClassificationTypes()
{
    global $SysConfig;

    # print option list for UI
    $Schema = new MetadataSchema();
    $FieldNames = $Schema->GetFieldNames(MetadataSchema::MDFTYPE_TREE);

    # transform field names to displayable labels
    foreach ($FieldNames as $Id => $Name)
    {
        $FieldNames[$Id] = $Schema->GetFieldByName($Name)->GetDisplayName();
    }

    PrintOptionList("F_BrowsingFieldId", $FieldNames,
                    $SysConfig->BrowsingFieldId(),
                    FALSE, 1, NULL, FALSE);
}

function PrintCheckedWhen($Option, $Value)
{
    global $SysConfig;
    if ($SysConfig->{$Option}() == $Value){ print("checked"); }
}

function PrintCheckedIf($Option)
{
    global $SysConfig;
    if ($SysConfig->{$Option}()) {  print("checked");  }
}
function PrintCheckedIfNot($Option)
{
    global $SysConfig;
    if (!$SysConfig->{$Option}()) {  print("checked");  }
}

function PrintCheckedIfSearchTermHandlingIsAnd()
{
    global $SysConfig;
    if ($SysConfig->SearchTermsRequired()) {  print("checked");  }
}
function PrintCheckedIfSearchTermHandlingIsOr()
{
    global $SysConfig;
    if (!$SysConfig->SearchTermsRequired()) {  print("checked");  }
}
function PrintCheckedIfReleaseFlagApproved()
{
    global $SysConfig;
    if ($SysConfig->ReleaseFlagApproved()) {  print("checked");  }
}
function PrintCheckedIfReleaseFlagNotApproved()
{
    global $SysConfig;
    if (!$SysConfig->ReleaseFlagApproved()) {  print("checked");  }
}

function PrintGoogleAnalyticsCode()
{
    global $SysConfig;
    print($SysConfig->GoogleAnalyticsCode());
}

function PrintActiveUIOptionList()
{
    global $SysConfig;

    # print option list for UI
    print(GetActiveUIOptionList($SysConfig->DefaultActiveUI()));
}

function PrintCharacterSetOptionList()
{
    global $SysConfig;

    # print option list for character coding
    $CharSets = array("ISO-8859-1", "UTF-8");

    $Text = "";
    foreach ($CharSets as $CharSet)
    {
        if ($SysConfig->DefaultCharacterSet() == $CharSet)
            $Select = " selected";
        else
            $Select = NULL;

        $Text .= "<option value=\"$CharSet\"$Select>$CharSet</option>\n";
    }
    print($Text);
}

function PrintDefaultNumSearchResultsOptionlist()
{
    global $SysConfig;

    $RecordsPerPage = array(
        "5" => 5,
        "10" => 10,
        "20" => 20,
        "30" => 30,
        "50" => 50,
        "100" => 100);

    PrintOptionList(
        "F_DefaultRecordsPerPage", $RecordsPerPage,
        $SysConfig->DefaultRecordsPerPage());
}

function PrintSiteKeywords()
{
    global $SysConfig;

    # print the keywords as stored in the SysConfig object
    print($SysConfig->SiteKeywords());
}

/**
 * Print the options for the default privileges of new users.
 */
function PrintDefaultUserPrivsOptionList()
{
    global $SysConfig;

    $PrivilegeFactory = new PrivilegeFactory();
    $Privileges = $PrivilegeFactory->GetPrivileges(TRUE);
    $SelectedPrivileges = $SysConfig->DefaultUserPrivs();

    $SelectedByDefault = array();
    $DisabledByDefault = array();

    foreach ($Privileges as $Privilege)
    {
        $PrivilegeId = $Privilege->Id();
        $Selected = in_array($PrivilegeId, $SelectedPrivileges);
        $Disabled = FALSE;

        # select if flagged to be selected by default
        $Selected = $Selected || in_array($PrivilegeId, $SelectedByDefault);

        # disable if flagged to be disabled by default
        $Disabled = $Disabled || in_array($PrivilegeId, $DisabledByDefault);

        PrintDefaultUserPriv($Privilege, $Selected, $Disabled);
    }
}

/**
 * Print the options for the default sort field on the advanced search results
 * page.
 */
function PrintDefaultSortFieldOptionList()
{
    global $SysConfig, $G_User;

    $Schema = new MetadataSchema();
    $PossibleSortFields = $Schema->GetFields(
        MetadataSchema::MDFTYPE_TEXT |
        MetadataSchema::MDFTYPE_NUMBER |
        MetadataSchema::MDFTYPE_DATE |
        MetadataSchema::MDFTYPE_TIMESTAMP |
        MetadataSchema::MDFTYPE_URL);
    $SelectedSortField = $SysConfig->DefaultSortField();

    PrintDefaultSortField(NULL, "Relevance");

    foreach ($PossibleSortFields as $Field)
    {
        $ViewingPrivilege = $Field->ViewingPrivilege();

        if ($Field->IncludeInSortOptions() &&
            (!$ViewingPrivilege || $G_User->HasPriv($ViewingPrivilege)))
        {
            $Selected = $Field->Id() == $SelectedSortField;
            PrintDefaultSortField($Field->Id(), $Field->GetDisplayName(), $Selected);
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function PrintValue($ValueName)
{
    global $SysConfig;
    global $Session;

    $FormVar = "F_".$ValueName;
    ${$FormVar} = $Session->Get($FormVar);
    if (isset(${$FormVar}))
    {
        print(htmlspecialchars(StripXSSThreats(${$FormVar})));
        $Session->UnregisterVariable($FormVar);
    }
    else
    {
        print(htmlspecialchars(StripXSSThreats($SysConfig->{$ValueName}())));
    }
}

# ----- MAIN -----------------------------------------------------------------

require_once "lib/AxisPHP/Axis--StandardLibrary.php";

global $G_Schema;

PageTitle("Edit System Configuration");
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

# insure that valid values are available
if ($G_SysConfig->Value("PreferredLinkValue") != "URL")
        {  $G_SysConfig->Value("PreferredLinkValue", "FILE");  }
if ($G_SysConfig->Value("TitlesLinkTo") != "RECORD")
        {  $G_SysConfig->Value("TitlesLinkTo", "URL");  }

$G_Schema = new MetadataSchema();
