<?PHP
#
#   FILE:  DBCleanUp.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

class DBCleanUp extends Plugin {

    function Register()
    {
        $this->Name = "Database Clean Up";
        $this->Version = "1.0.0";
        $this->Description = "Periodically looks for and removes"
                ." stray database entries, usually the result"
                ." of debugging or interim development code.";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
                "CWISCore" => "2.2.0");
        $this->EnabledByDefault = FALSE;

        $this->CfgSetup["Frequency"] = array(
                "Type" => "Option",
                "Label" => "Cleanup Frequency",
                "Help" => "How often database cleanup should be run.",
                "Options" => array(
                        DBCleanUp::FREQ_DAILY => "Daily",
                        DBCleanUp::FREQ_WEEKLY => "Weekly",
                        DBCleanUp::FREQ_MONTHLY => "Monthly",
                        ),
                );
    }

    function Install()
    {
        $this->ConfigSetting("Frequency", DBCleanUp::FREQ_DAILY);
    }

    function HookEvents()
    {
        switch ($this->ConfigSetting("Frequency"))
        {
            case DBCleanUp::FREQ_DAILY:  $ToHook = "EVENT_DAILY";  break;
            case DBCleanUp::FREQ_MONTHLY:  $ToHook = "EVENT_MONTHLY";  break;
            case DBCleanUp::FREQ_WEEKLY:  $ToHook = "EVENT_WEEKLY";  break;
        }
        return array(
                $ToHook => "CleanUp",
                );
    }

    function CleanUp()
    {
        # clean up any links from controlled names to resources that no longer exist
        $DB = new Database();
        $DB->Query("DELETE FROM ResourceNameInts"
                ." WHERE ResourceId NOT IN (SELECT ResourceId FROM Resources);");

        # clean up any links from classifications to resources that no longer exist
        $DB->Query("DELETE FROM ResourceClass"
                ." WHERE ResourceId NOT IN (SELECT ResourceId FROM Resources);");
    }

    const FREQ_DAILY = 1;
    const FREQ_WEEKLY = 2;
    const FREQ_MONTHLY = 3;
}

?>
