<?PHP
#
#   FILE:  Update.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   OPTIONAL FUNCTIONS:
#       (none)
#
#   GET FIELDS EXPECTED:
#       Redirect
#           - page to redirect to
#       Action
#           - action to perform
#       ResourceId
#           - resource ID
#       FieldId
#           - field ID
#
#   Copyright 2009 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
 * Enable the given resource, i.e., set its Release Flag value to true.
 * @param $Resource resource to enable
 */
function EnableResource(Resource $Resource)
{
    $Resource->Set("Release Flag", 1);
}

/**
 * Disable the given resource, i.e., set its Release Flag value to false.
 * @param $Resource resource to disable
 */
function DisableResource(Resource $Resource)
{
    $Resource->Set("Release Flag", 0);
}

# ----- MAIN -----------------------------------------------------------------

# non-standard globals
global $PageName;
global $Redirect;
global $Action;
global $ResourceId;
global $FieldId;

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

# page information
$PageName = (isset($_GET["P"])) ? $_GET["P"] : "";

# passed variables
$Redirect = (isset($_GET["Redirect"])) ? $_GET["Redirect"] : "";
$Action = (isset($_GET["Action"])) ? $_GET["Action"] : "";
$ResourceId = (isset($_GET["ResourceId"])) ? intval($_GET["ResourceId"]) : 0;
$FieldId = (isset($_GET["FieldId"])) ? intval($_GET["FieldId"]) : 0;

# get resource and field objects
$Resource = new Resource($ResourceId);
$Field = new MetadataField($FieldId);

# proceed only if the resource and field are valid
if ($Resource->Status() && $Field->Status())
{
    switch ($Action)
    {
        case "Enable":
            EnableResource($Resource);
            $AF->SetJumpToPage($Redirect);
            break;
        case "Disable":
            DisableResource($Resource);
            $AF->SetJumpToPage($Redirect);
            break;
        default:
            $AF->SetJumpToPage($Redirect);
            break;
    }
}

# invalid resource or field
else
{
    $AF->SetJumpToPage($Redirect);
}

?>
