<?PHP

#
#   FILE:  SPT--PrivilegeFactory.php
#
#   METHODS PROVIDED:
#       PrivilegeFactory()
#           - constructor
#       SomeMethod($SomeParameter, $AnotherParameter)
#           - short description of method
#
#   AUTHOR:  Edward Almasy
#
#   Part of the Collection Workflow Integration System
#   Copyright 2007 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

  /**
   * Factory which extracts all defined privileges from the database
   * \nosubgrouping
   */

class PrivilegeFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /** @name Setup/Initialization */
    /*@{*/

    /** Object constructor */
    function PrivilegeFactory()
    {
        $this->ItemFactory("Privilege", "CustomPrivileges", "Id", "Name");
    }
    
    /*@}*/

    /** @name Accessors */
    /*@{*/
    
    /**
     * Get all privileges
     * @param IncludePredefined (OPTIONAL)
     * @param ReturnObjects (OPTIONAL)
     * @return An array of privilege objects or strings with
     *   the priv id for the index
     */
    function GetPrivileges($IncludePredefined = TRUE, $ReturnObjects = TRUE)
    {
        # read custom privileges in from DB
        $PrivNames = $this->GetItemNames();

        # add in predefined privileges if requested
        if ($IncludePredefined)
        {
            global $G_PrivDescriptions;
            $PrivNames = $G_PrivDescriptions + $PrivNames;
        }

        # if caller requested objects to be returned
        if ($ReturnObjects)
        {
            # convert strings to objects and return to caller
            foreach ($PrivNames as $Id => $Name)
            {
                $PrivObjects[$Id] = new Privilege($Id);
            }
            return $PrivObjects;
        }
        else
        {
            # return strings to caller
            return $PrivNames;
        }
    }

    /*@}*/

    # ---- PRIVATE INTERFACE -------------------------------------------------

}


?>
