<?PHP

#
#   FILE:  SPT--EditSysConfig.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# functions to return sys config info (for insertion into forms)
function PrintPortalName() {  PrintValue("PortalName");  }
function PrintAdminEmail() {  PrintValue("AdminEmail");  }
function PrintNumClassesPerBrowsePage() {  PrintValue("NumClassesPerBrowsePage");  }
function PrintNumColumnsPerBrowsePage() {  PrintValue("NumColumnsPerBrowsePage");  }
function PrintClassificationTypes()
{
    global $SysConfig;

    # print option list for UI
    $Schema = new MetadataSchema();
    $FieldNames = $Schema->GetFieldNames();
    PrintOptionList("F_BrowsingFieldId", $FieldNames,
                    $SysConfig->BrowsingFieldId(),
                    FALSE, 1, NULL, FALSE);
}
function PrintNumAnnounceOnHomePage() {  PrintValue("NumAnnounceOnHomePage");  }
function PrintNumResourcesOnHomePage() {  PrintValue("NumResourcesOnHomePage");  }
function PrintLegalNotice() { PrintValue("LegalNotice"); }
function PrintCheckedIfSearchTermHandlingIsAnd()
{
    global $SysConfig;
    if ($SysConfig->SearchTermsRequired()) {  print("checked");  }
}
function PrintCheckedIfSearchTermHandlingIsOr()
{
    global $SysConfig;
    if (!$SysConfig->SearchTermsRequired()) {  print("checked");  }
}
function PrintCheckedIfAnnouncementsEnabled()
{
    global $SysConfig;
    if ($SysConfig->AnnouncementsEnabled()) {  print("checked");  }
}
function PrintCheckedIfAnnouncementsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->AnnouncementsEnabled()) {  print("checked");  }
}
function PrintCheckedIfForumsEnabled()
{
    global $SysConfig;
    if ($SysConfig->ForumsEnabled()) {  print("checked");  }
}
function PrintCheckedIfForumsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->ForumsEnabled()) {  print("checked");  }
}
function PrintCheckedIfAllowMultipleUIsEnabled()
{
    global $SysConfig;
    if ($SysConfig->AllowMultipleUIsEnabled()) {  print("checked");  }
}
function PrintCheckedIfAllowMultipleUIsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->AllowMultipleUIsEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceLaunchesNewWindowEnabled()
{
    global $SysConfig;
    if ($SysConfig->ResourceLaunchesNewWindowEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceLaunchesNewWindowDisabled()
{
    global $SysConfig;
    if (!$SysConfig->ResourceLaunchesNewWindowEnabled()) {  print("checked");  }
}
function PrintCheckedIfUserAgentsEnabled()
{
    global $SysConfig;
    if ($SysConfig->UserAgentsEnabled()) {  print("checked");  }
}
function PrintCheckedIfUserAgentsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->UserAgentsEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceRatingsEnabled()
{
    global $SysConfig;
    if ($SysConfig->ResourceRatingsEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceRatingsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->ResourceRatingsEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceCommentsEnabled()
{
    global $SysConfig;
    if ($SysConfig->ResourceCommentsEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceCommentsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->ResourceCommentsEnabled()) {  print("checked");  }
}
function PrintCheckedIfAccessibilityWizardEnabled()
{
    global $SysConfig;
    if ($SysConfig->AccessibilityWizardEnabled()) {  print("checked");  }
}
function PrintCheckedIfAccessibilityWizardDisabled()
{
    global $SysConfig;
    if (!$SysConfig->AccessibilityWizardEnabled()) {  print("checked");  }
}
function PrintCheckedIfSearchDBEnabled()
{
    global $SysConfig;
    if ($SysConfig->SearchDBEnabled()) {  print("checked");  }
}
function PrintCheckedIfSearchDBDisabled()
{
    global $SysConfig;
    if (!$SysConfig->SearchDBEnabled()) {  print("checked");  }
}
function PrintCheckedIfRecommenderDBEnabled()
{
    global $SysConfig;
    if ($SysConfig->RecommenderDBEnabled()) {  print("checked");  }
}
function PrintCheckedIfRecommenderDBDisabled()
{
    global $SysConfig;
    if (!$SysConfig->RecommenderDBEnabled()) {  print("checked");  }
}
function PrintCheckedIfOAISQEnabled()
{
    global $SysConfig;
    if ($SysConfig->OAISQEnabled()) {  print("checked");  }
}
function PrintCheckedIfOAISQDisabled()
{
    global $SysConfig;
    if (!$SysConfig->OAISQEnabled()) {  print("checked");  }
}
function PrintCheckedIfReleaseFlagApproved()
{
    global $SysConfig;
    if ($SysConfig->ReleaseFlagApproved()) {  print("checked");  }
}
function PrintCheckedIfReleaseFlagNotApproved()
{
    global $SysConfig;
    if (!$SysConfig->ReleaseFlagApproved()) {  print("checked");  }
}
function PrintCheckedIfAddAWStatsScriptEnabled()
{
    global $SysConfig;
    if ($SysConfig->AddAWStatsScript()) {  print("checked");  }
}
function PrintCheckedIfAddAWStatsScriptDisabled()
{
    global $SysConfig;
    if (!$SysConfig->AddAWStatsScript()) {  print("checked");  }
}
function PrintCheckedIfGoogleAnalyticsEnabled()
{
    global $SysConfig;
    if ($SysConfig->AddGoogleAnalytics()) {  print("checked");  }
}
function PrintCheckedIfGoogleAnalyticsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->AddGoogleAnalytics()) {  print("checked");  }
}

function PrintGoogleAnalyticsCode()
{
    global $SysConfig;
    print($SysConfig->GoogleAnalyticsCode());
}

function PrintActiveUIOptionList()
{
    global $SysConfig;

    # print option list for UI
    print(GetActiveUIOptionList($SysConfig->DefaultActiveUI()));
}

function PrintThemeOptionList()
{
    global $SysConfig;

    # print option list for UI
    print(GetThemeOptionList($SysConfig->CurrentTheme()));
}

function PrintCharacterSetOptionList()
{
    global $SysConfig;

    # print option list for character coding
    $CharSets = array("ISO-8859-1", "UTF-8");

    $Text = "";
    foreach ($CharSets as $CharSet)
    {
        if ($SysConfig->DefaultCharacterSet() == $CharSet)
            $Select = " selected";
        else
            $Select = NULL;
            
        $Text .= "<option value=\"$CharSet\"$Select>$CharSet</option>\n";
    }
    print($Text);
}

function PrintSiteKeywords()
{
    global $SysConfig;

    # print the keywords as stored in the SysConfig object
    print($SysConfig->SiteKeywords());
}

function PrintAboutText() { PrintValue("AboutText"); }

function IsOkayToDisplayThemeSelection()
{
    global $SysConfig;
    return FALSE;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function PrintValue($ValueName)
{
    global $SysConfig;
    global $Session;

    $FormVar = "F_".$ValueName;
    ${$FormVar} = $Session->Get($FormVar);
    if (isset(${$FormVar}))
    {
        print(${$FormVar});
        $Session->UnregisterVariable($FormVar);
    }
    else
    {
        print($SysConfig->{$ValueName}());
    }
}

function GetThemeOptionList($Selected)
{
    # start out with empty list
    $Text = "";

    # for each file in current interface directory
    global $SysConfig;
    $Dir = dir("./".$SysConfig->DefaultActiveUI()."/Themes");
    while (($DirEntry = $Dir->read()) !== FALSE)
    {
        # if file is directory
        $FullDirName = "./".$SysConfig->DefaultActiveUI()."/Themes/".$DirEntry;
        if (is_dir($FullDirName) && preg_match("/Theme--[a-zA-Z]+/", $DirEntry))
        {
            # read UI name (if available)
            $UIName = "";
            $UINameFile = $FullDirName."/NAME";
            if (is_readable($UINameFile))
            {
                $FHandle = fopen($UINameFile, "r");
                $UIName = fgets($FHandle, 64);
                fclose($FHandle);
            }
            if (strlen($UIName) < 1) {  $UIName = $DirEntry;  }

            # print option tag for UI
            if ($DirEntry == $Selected) {  $Select = " selected";  } else {  $Select = "";  }
            $Text .= "<option value=\"${DirEntry}\"${Select}>${UIName}</option>\n";
        }
    }

    # return list to caller
    return $Text;
}


# ----- MAIN -----------------------------------------------------------------

PageTitle("Edit System Configuration");
if (!CheckAuthorization(PRIV_SYSADMIN)) {  return;  }

?>
