<?php
#
#   FILE:  SPT--EditControlledNameComplete.php
#
#   FUNCTIONS PROVIDED:
#       DisplayControlledNameInfo()
#           - updates or deletes ControlledName fields from ControlledNames
#             and VariantNames, and updates DateLastModified for affected
#             Resources
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# display list of modified controlled names
function DisplayControlledNameList()
{
    global $CNArray;

    foreach($CNArray as $CNName => $CNVariant)
    {
        print $CNName;
        if(!empty($CNVariant))
            print ", Variant ($CNVariant)";
        print "<br>";
    }
}

# display list of deleted controlled names
function DisplayDeletedControlledNameList()
{
    global $CNArray_Delete;

    foreach($CNArray_Delete as $CNName => $CNVariant)
    {
        print $CNName;
        if(!empty($CNVariant))
            print ", Variant ($CNVariant)";
        print "<br>";
    }
}

# display the list of modified resources
function DisplayModifiedResourceList()
{
    global $LinkArray;

    foreach ($LinkArray as $LinkIndex => $LinkString)
    {
        print $LinkString;
    }
}

function ProcessControlledNames()
{
    global $F_ControlledName;
    global $Session;
    global $CNArray;
    global $CNArray_Delete;
    global $Submit;

    $CNArray = array();
    $CNArray_Delete = array();

    $Delete = FALSE;
    reset($_POST);
    # we assume that ControlledNameId comes before ControlledName
    while (list($Var, $Val) = each ($_POST))
    {
        if (preg_match("/^F_ControlledNameId_([0-9]+)/",$Var,$Regs))
        {
            unset($QualifierId);        # default QualifierId to NULL
            $Delete = FALSE;            # Assume no delete
            $ControlledNameId = $Val;
            continue;
        }
        if (preg_match("/^F_ControlledName_([0-9]+)/",$Var,$Regs))
        {
            $ControlledName = $Val;
            $ControlledName = trim($ControlledName);
            continue;
        }
        if (preg_match("/^D_Remap_([0-9]+)/",$Var, $Regs))
        {
            $D_Remap = trim($Val);
            continue;
        }
        if (preg_match("/^F_QualifierName_([0-9]+)/",$Var,$Regs))
        {
            $QualifierId = $Val;
            # if "--" selected, set qualifier id = NULL
            if ($QualifierId == "--")
                $QualifierId = "NULL";
            continue;
        }
        if (preg_match("/^F_Delete_([0-9]+)/",$Var,$Regs))
        {

            $Delete = TRUE;
            continue;
        }
        if (preg_match("/^F_VariantName_([0-9]+)/",$Var,$Regs))
        {
            $VariantName = $Val;
            $VariantName = trim($VariantName);
        }

#        echo "VN=$VariantName, CN=$ControlledName, CNID=$ControlledNameId<br>";
#        echo "FieldId=$F_FieldId, Check=$Check, QID=$QualifierId<br>";

        # update the values for each controlled name
        if (!empty($ControlledName))
        {
            $CN = new ControlledName($ControlledNameId);
            if ($Delete)
            {
                $CNArray_Delete[$CN->Name()] = $CN->Variant();
                $CN->Delete(TRUE);
            }
            else
            {
                if (strlen($D_Remap)>0)
                {
                    $CNArray[] = $ControlledNameId;
                    $OtherIds = ControlledName::SearchForControlledName(
                        $D_Remap, $CN->FieldId() );
                    if (!empty($OtherIds))
                    {
                        $OtherId = array_shift($OtherIds);
                        $CN->RemapTo($OtherId);
                    }
                }
                else
                {
                    if ($CN->Name() != $ControlledName)
                    {
                        $CNArray[] = $ControlledNameId;
                        $CN->Name($ControlledName);
                    }

                    if (isset($QualifierId))
                    {
                        if ($CN->QualifierId != $QualifierId)
                        {
                            $CNArray[] = $ControlledNameId;
                            $CN->QualifierId($QualifierId);
                        }
                    }

                    if ($CN->Variant() != $VariantName)
                    {
                        $CNArray[] = $ControlledNameId;
                        $CN->Variant($VariantName);
                    }
                }
            }
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# update any checked records
function UpdateCheckedValues()
{
    global $Submit;
    global $CNArray;
    global $CNArray_Delete;
    global $LinkArray;

    $DB = new SPTDatabase();
    $DB2 = new SPTDatabase();
    $SearchEngine = new SPTSearchEngine();
    $LinkIndex = 0;
    $LinkArray = array();
    $NewCNArray = array();

    foreach ($CNArray as $CNId)
    {
        # cache controlled name and variant for display purposes
        $CN = new ControlledName($CNId);
        $NewCNArray[$CN->Name()] = $CN->Variant();

        # now update DateLastModified for all affected Resources if updating
        $Query = "Select distinct Resources.ResourceId, Title from ".
             "Resources INNER JOIN ResourceNameInts ON ".
             "ResourceNameInts.ResourceId=Resources.ResourceId ".
             "WHERE ControlledNameId = $CNId ".
             "ORDER BY Resources.ResourceId";

        $DB->Query($Query);

        $Rows = $DB->NumRowsSelected();
        for ($Index=0; $Index<$Rows; $Index++)
        {
            $Result = $DB->FetchRow();

            $LinkArray[$LinkIndex++] =
                "<a href=\"index.php?P=FullRecord&amp;ResourceId=".
                $Result["ResourceId"]."\" target=\"_blank\">".
                $Result["Title"]."</a><br>";
            $UpdateQuery = "Update Resources set ".
                "DateLastModified = '".date("Y-m-d H:i:s").
                "' where ResourceId = ".$Result["ResourceId"];
            $DB2->Query($UpdateQuery);

            # update the Search DB for this controlled name & resource
            $SearchEngine->UpdateForResource($Result["ResourceId"]);
        }
    }
    $CNArray = $NewCNArray;
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $CNArray;
global $CNArray_Delete;
global $F_ControlledName;
global $LinkArray;
global $Submit;

if (!CheckAuthorization(PRIV_NAMEADMIN)) {  return;  }

$Submit = $_POST["Submit"];

# check for actual deletion
if ($Submit == "Save Changes")
{
    ProcessControlledNames();
    UpdateCheckedValues();
}
else if ($Submit == "Cancel")
{
    $AF->SetJumpToPage("EditControlledName");
}

PageTitle("Edit Controlled Name Complete");


?>
