<?PHP
#
#   FILE:  RequestAccount.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintStatesOptionList($ResultVar)
{
    global $FTool;

    $States = FormTool::GetArrayOfUsStates();
    $SelectedValue = $FTool->ValueForField($ResultVar);

    PrintOptionList($ResultVar, $States, $SelectedValue);
}

function PrintFormFieldValue($Name)
{
    global $FTool;

    print defaulthtmlentities($FTool->ValueForField($Name));
}

# ----- MAIN -----------------------------------------------------------------

require_once "include/SPT--Form--RequestAccount.php";

global $FTool;

PageTitle("New User Sign-Up");

# set up expectations for incoming form
$AdditionalErrorMessages = array(
        U_PASSWORDSDONTMATCH   => "The two passwords you entered did not match.",
        U_EMAILSDONTMATCH   => "The two e-mail addresses you entered did not match.",
        U_DUPLICATEUSERNAME => "The user name you entered is already in use.",
        U_ILLEGALUSERNAME   => "The user name you entered is not valid."
                ." User names must be made up of one word containing between 2 and 24"
                ." letters and/or numbers.",
        U_MAILINGERROR      => "An error was encountered trying to send an"
                ." e-mail message to activate your new account.  Please contact the"
                ." administrator of this site and inform them of the problem.",
        U_EMPTYPASSWORD => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_EMPTYPASSWORDAGAIN => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_ILLEGALPASSWORD => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_ILLEGALPASSWORDAGAIN => "Please enter a password at least 6 characters long"
                ." into both password fields below.",
        U_DUPLICATEEMAIL => "The e-mail address you entered is already associated"
                ." with an account.  If you have forgotten the account user name or"
                ." password you can click"
                ." <a href=\"index.php?P=ForgottenPasswordComplete&UN="
                        .(isset($_GET["F_EMail"]) ? $_GET["F_EMail"] : "")
                        ."\">here</a>"
                ." to send a reminder via e-mail.",
        );

$AdditionalErrorMessages =
    $AF->SignalEvent("EVENT_USER_SIGNUP_EXTEND_ERROR_LIST",
                     array( $AdditionalErrorMessages));

$FTool = new FormTool($FormFields, $AdditionalErrorMessages);
$FTool->SetFieldValuesFromUrlParams();
