<?php

#
#   FILE:  SPT--ImportData.php
#
#   FUNCTIONS PROVIDED:
#       PrintErrorMessage()
#           - print an error message
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

include_once("lib/AxisPHP/Axis--StandardLibrary.php");  # (for PrintOptionList())

function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if (!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

function PrintUniqueFieldList()
{
    $Values = array();

    # first entry is empty
    $Values["-1"] = "None Selected";

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(
        MetadataSchema::MDFTYPE_TEXT |
        MetadataSchema::MDFTYPE_PARAGRAPH |
        MetadataSchema::MDFTYPE_NUMBER |
        MetadataSchema::MDFTYPE_URL );
    foreach ($Fields as $Field)
        if ($Field->Enabled())
            $Values[$Field->Name()] = $Field->Name();

    PrintOptionList("F_UniqueField", $Values, "-1", NULL, 1, NULL, false);


}

PageTitle("Import Data");

# check if current user is authorized
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

?>
