/**
 * Browser fixes for generic.css. This file depends on jQuery.
 */

jQuery(document).ready(function($){
    var majorVersion = parseInt($.browser.version, 10);

/* @group Setup
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/

/* @end
<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

/* @group Elements
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/

/* @end
<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

/* @group Segment / Page Layout
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/

if ($.browser.msie && majorVersion < 8) {

    /* resize the body segment on page load and when the window is resized */
    resizeBodySegment();
    $(window).resize(resizeBodySegment);

    function resizeBodySegment(){
        var newWidth = $(window).width() - 250;

        if (newWidth > 300) {
            $("#cw-segment-toolbox").parent().css({
                "vertical-align": "top",
                "width": "200px",
                "height": "100%"});

            $("#cw-segment-body").css("width", newWidth+"px");
        }
    }

}

/* @end
<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

/* @group Content
>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>*/

if ($.browser.msie && majorVersion < 9) {
    $("form > .cw-table:last-child").css({
        "margin-bottom": "0"});

    /* edit resource table */
    $("table.cw-content-editresourcetable > tbody > tr > td:last-child").css({
        "text-align": "right"});

    /* controlled name table */
    $("table.cw-content-cnametable > tbody > tr > th:nth-child(2)").css({
        "text-align": "left"});

    /* system configuration table */
    $("table.cw-content-sysconfigtable > tbody > tr > td:nth-child(3)").css({
        "font-size": "0.8em"});

    /* plugins table */
    $("table.cw-content-plugintable > tbody > tr > td:last-child").css({
        "text-align": "center"});

    $("table.cw-content-plugintable > tbody > tr > td:nth-child(5)").css({
        "white-space": "nowrap"});

    $("table.cw-content-plugintable > tbody > tr > td:nth-child(5) > ul").css({
        "margin-top": "0",
        "margin-bottom": "0"});

    /* accessibility form */
    $("form.cw-content-accessibilityform > fieldset:first-of-type").css({
        "margin-top": "0"});

    /* sysadmin rows/boxes */
    $(".cw-content-sysadminrow.cw-table-fauxtable .cw-table-fauxrow\
       .cw-table-fauxcell:last-child").css({
        "width": "49%",
        "padding-top": "0",
        "padding-bottom": "0"});

    $(".cw-content-sysadminrow.cw-table-fauxtable .cw-table-fauxrow\
       .cw-table-fauxcell:nth-child(2)").css({
        "width": "10px"});

    /* request account table */
    $("table.cw-content-reqaccttable > tbody > tr:nth-child(2) > th,\
       table.cw-content-reqaccttable > tbody > tr:nth-child(2) > td").css({
        "padding-top": "25px"});

    $("table.cw-content-reqaccttable > tbody > tr:last-child > th,\
       table.cw-content-reqaccttable > tbody > tr:last-child > td").css({
        "padding-bottom": "25px"});

    $("table.cw-content-reqaccttable > tbody > tr:nth-child(n+2) > th").css({
        "width": "150px"});

    /* complex, table-model headers */
    $(".cw-content-complexheader.cw-table-fauxtable > .cw-table-fauxrow\
       > .cw-table-fauxcell:last-child").css({
        "text-align": "right"});

    /* forum tables */
    $("table.cw-content-forumtable > tbody > tr > td:nth-child(n+2)").css({
        "text-align": "center"});

    /* collection development stats */
    $("table.cw-content-colstats > tbody > tr > td:nth-child(2)").css({
        "text-align": "right"});

    /* options for an option list */
    $("table.cw-content-optionoptions > tbody > tr:last-child").css({
        "background-color": "#FFFFFF"});

    $("table.cw-content-optionoptions > tbody > tr:last-child > td:last-child").css({
        "text-align": "right"});

    $(".cw-content-forummessage.cw-section > .cw-section-header > .cw-table-fauxtable"+
       " > .cw-table-fauxrow > .cw-table-fauxcell:nth-child(2)").css({
        "width": "120px",
        "border-left": "1px solid #CCC",
        "border-right": "1px solid #CCC",
        "text-align": "center"});

    $(".cw-content-forummessage.cw-section > .cw-section-header > .cw-table-fauxtable"+
      " > .cw-table-fauxrow > .cw-table-fauxcell:last-child").css({
        "width": "220px",
        "text-align": "center"});

    /* full record rating */
    $(".cw-content-fullrecord > .cw-table-fauxtable.cw-content-rating >"+
      " .cw-table-fauxrow > .cw-table-fauxcell:last-child").css({
        "padding-left": "12px",
        "text-align": "right",
        "font-size": "0.85em",
        "vertical-align": "middle"});

    $(".cw-content-fullrecord > .cw-table-fauxtable.cw-content-rating >"+
      " .cw-table-fauxrow > .cw-table-fauxcell:last-child img").css({
        "margin-right": "10px"});

    $(".cw-content-fullrecord > .cw-table-fauxtable.cw-content-rating >"+
      " .cw-table-fauxrow > .cw-table-fauxcell:last-child input[type=radio]").css({
        "margin-left": "1px",
        "margin-right": "1px"});

    $(".cw-content-fullrecord > .cw-table-fauxtable.cw-content-rating >"+
      " .cw-table-fauxrow > .cw-table-fauxcell:last-child input[type=submit]").css({
        "margin-left": "5px"});

    /* full record final details */
    $(".cw-content-fullrecord .cw-table-fauxtable.cw-content-finaldetails"+
      " > .cw-table-fauxrow > .cw-table-fauxcell:last-child").css({
        "text-align": "right"});

    /* full record comment bar */
    $(".cw-content-fullrecord .cw-table-fauxtable.cw-content-commentbar"+
      " > .cw-table-fauxrow > * + .cw-table-fauxcell:last-child").css({
        "text-align": "right"});

    /* new resources table */
    $(".cw-section.cw-content-newresources > .cw-section-body > table:last-child").css({
        "border-bottom": "none"});

    $(".cw-section.cw-content-newresources > .cw-section-footer"+
      " > .cw-table.cw-table-fauxtable > .cw-table-fauxrow"+
      " > .cw-table-fauxcell:nth-child(2)").css({
        "width": "40%",
        "text-align": "center"});

    $(".cw-section.cw-content-newresources > .cw-section-footer"+
      " > .cw-table.cw-table-fauxtable > .cw-table-fauxrow"+
      " > .cw-table-fauxcell:last-child").css({
        "text-align": "right"});
}

/* @end
<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

});
