<?PHP
#
#   FILE:  FieldRedacter.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

class FieldRedacter extends Plugin {

    function Register()
    {
        $this->Name = "Field Redacter";
        $this->Version = "1.0.0";
        $this->Description = "Allows values for a specified field to be"
                ." replaced with specified text when displayed, when user"
                ." is not logged in.";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
                "CWISCore" => "2.2.2");
        $this->EnabledByDefault = FALSE;

        $this->CfgSetup["FieldToFilter"] = array(
                "Type" => "MetadataField",
                "Label" => "Field to Filter",
                "Help" => "Field to replace when being displayed.",
                "FieldTypes" => MetadataSchema::MDFTYPE_TEXT
                        | MetadataSchema::MDFTYPE_PARAGRAPH
                        | MetadataSchema::MDFTYPE_NUMBER
                        | MetadataSchema::MDFTYPE_DATE
                        | MetadataSchema::MDFTYPE_TIMESTAMP
                        | MetadataSchema::MDFTYPE_URL,
                );
        $this->CfgSetup["ReplacementText"] = array(
                "Type" => "Paragraph",
                "Label" => "Replacement Text",
                "Help" => "Text to display in place of field value.",
                "Columns" => 60,
                );
    }

    function Install()
    {
        $Schema = new MetadataSchema;
        $FieldId = $Schema->StdNameToFieldMapping("Url");
        if ($FieldId !== NULL)
        {
            $this->ConfigSetting("FieldToFilter", $FieldId);
            $this->ConfigSetting("ReplacementText", 
                    "You must be logged in to access all resource information.");
        }
    }

    function HookEvents()
    {
        return array(
                "EVENT_FIELD_DISPLAY_FILTER" => "FilterValues",
                );
    }

    function FilterValues($Field, $Resource, $Value)
    {
        if (($Field->Id() == $this->ConfigSetting("FieldToFilter"))
                && !$GLOBALS["G_User"]->IsLoggedIn())
        {
            $Value = $this->ConfigSetting("ReplacementText");
        }
        return array(
                "Field" => $Field, 
                "Resource" => $Resource, 
                "Value" => $Value);
    }
}

?>
