<?PHP

#
#   FILE:  SPT--UpdateForum.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# remove selected forum 
function RemoveForum()
{
    global $_POST, $Session;

    $F_ForumId = $_POST["F_ForumId"];
    if (is_null($F_ForumId))
        $F_ForumId = $Session->Get("F_ForumId");

    if (!empty($F_ForumId))
    {
        $Forum = new Forum($F_ForumId);
        $Forum->Delete();
    }
}

# add new forum 
function AddForum()
{
    global $F_ForumName, $F_ForumDescription, $F_ForumModeratorId, $AF;
    global $Session, $_POST;

    $F_ForumName = $_POST["F_ForumName"];
    if (is_null($F_ForumName))
        $F_ForumName = $Session->Get("F_ForumName");

    $F_ForumDescription = $_POST["F_ForumDescription"];
    if (is_null($F_ForumDescription))
        $F_ForumDescription = $Session->Get("F_ForumDescription");
        
    # make sure not empty strings
    if (strlen($F_ForumName) && strlen($F_ForumDescription))
    {
        $Forum = new Forum();
        $Forum->ForumName($F_ForumName);
        $Forum->ForumDescription($F_ForumDescription);
        $Forum->TopicCount("0");
        $Forum->MessageCount("0");
        $Forum->ModeratorId($F_ForumModeratorId);
    }
    else
    {
        $ErrorMessages[] = 
            "Error: Forum name and description are required fields.";
        $Session->PassVariable("ErrorMessages", $ErrorMessages);
        $Session->PassVariable("F_ForumName", $F_ForumName);
        $Session->PassVariable("F_ForumDescription", $F_ForumDescription);
        $AF->SetJumpToPage("AddForum");
        exit;
    }
}

# edit selected forum
function EditForum()
{
    global $Session, $F_ForumId;

    $Forum = new Forum($F_ForumId);
    $Session->PassVariable("F_ForumDescription", $Forum->ForumDescription());
    $Session->PassVariable("F_ForumName", $Forum->ForumName());
    $Session->PassVariable("Edit", 1);
}

# update selected forum
function UpdateForum()
{
    global $_POST, $Session, $F_ForumId, $F_ForumModeratorId;

    $F_ForumName = $_POST["F_ForumName"];
    if (is_null($F_ForumName))
        $F_ForumName = $Session->Get("F_ForumName");

    $F_ForumDescription = $_POST["F_ForumDescription"];
    if (is_null($F_ForumDescription))
        $F_ForumDescription = $Session->Get("F_ForumDescription");

    $Forum = new Forum($F_ForumId);
    $Forum->ForumName($F_ForumName);
    $Forum->ForumDescription($F_ForumDescription);
    $Forum->ModeratorId($F_ForumModeratorId);
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $F_ForumDescription;
global $F_ForumId;
global $F_ForumModeratorId;
global $F_ForumName;
global $_POST;

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }

if (isset($_POST["Submit"]))
    $Submit = $_POST["Submit"];
else
    $Submit = NULL;

if (isset($_POST["F_ForumId"]))
    $F_ForumId = $_POST["F_ForumId"];
else    
    $F_ForumId = $Session->Get("F_ForumId");

if (isset($_POST["F_ForumModeratorId"]))
    $F_ForumModeratorId = $_POST["F_ForumModeratorId"];
else
    $F_ForumModeratorId = NULL;

# check for Cancel button from previous screen
if ($Submit=="Cancel")
{
    $AF->SetJumpToPage("Home");
}
else if (substr($Submit, 0, 6) == "Remove")
{
    RemoveForum();
    unset($F_ForumId);
}
else if (substr($Submit, 0, 3) == "Add")
{
    AddForum();
}
else if (substr($Submit, 0, 4) == "Edit")
{
    EditForum();
}
else if (substr($Submit, 0, 6) == "Update")
{
    UpdateForum();
}

# return to add forum page
if (isset($F_ForumId))
{
    $Session->PassVariable("F_ForumId", $F_ForumId);
    $Session->PassVariable("F_ForumModeratorId", $F_ForumModeratorId);
} 
$AF->SetJumpToPage("AddForum");

?>
