<?php
#
#   FILE:  SPT--PostMessage.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       DisplayAddButtons()
#           - display add, delete, cancel buttons
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function CheckForEdit()
{
    global $MessageId, $User, $ModeratorId, $PosterId;

    if (!empty($MessageId) && ($User->Get("UserId") == $ModeratorId ||
        $User->Get("UserId") == $PosterId || $User->HasPriv(PRIV_SYSADMIN)))
        return true;
    else
        return false;
}

function PrintForumId()
{
    global $ForumId;

    print $ForumId;
}

function PrintForumName()
{
    global $ForumName;

    print stripslashes($ForumName);
}

function PrintParentId()
{
    global $ParentId;

    print $ParentId;
}

function PrintTopic()
{
    global $F_TopicName;

    print stripslashes($F_TopicName);
}

function PrintMessageId()
{
    global $MessageId;

    print stripslashes($MessageId);
}

function PrintSubject()
{
    global $F_Subject;

    print GetHtmlEscapedString($F_Subject);
}

function PrintBody()
{
    global $F_Body;

    # filter out "Edited by:" text
    $loc = strpos($F_Body, "<br><br><small>This message edited by");
    if ($loc === false)
        print GetHtmlEscapedString($F_Body);
    else
        print GetHtmlEscapedString(substr($F_Body, 0, $loc - 2));
}

# print out any error messages
function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed
    if (count($ErrorMessages) > 0)
    {
        if (function_exists("PrintErrorMessage"))
        {
            foreach ($ErrorMessages as $Message)
            {
                PrintErrorMessage($Message);
            }
        }

        else
        {
            # print error messages
            print("<ul>\n");
            foreach ($ErrorMessages as $Message)
            {
                printf("<li>%s</li>\n", $Message);
            }
            print("</ul>\n");
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $F_Body;
global $F_Subject;
global $F_TopicName;
global $ForumId;
global $ForumName;
global $MessageId;
global $ModeratorId;
global $ParentId;
global $PosterId;


if (isset($_GET["TopicId"]))
{
    $TopicId = intval($_GET["TopicId"]);
    $ParentId = $TopicId;
}
else if ($Session->IsRegistered("TopicId"))
{
    $TopicId = $Session->Get("TopicId");
    $ParentId = $TopicId;
}

if (isset($TopicId))
    $Topic = new Topic($TopicId);

$F_TopicName = $Topic->TopicName();

if (isset($_GET["ForumId"]))
    $ForumId = intval($_GET["ForumId"]);
else if($Session->IsRegistered("ForumId"))
    $ForumId = $Session->Get("ForumId");

if (isset($ForumId))
    $Forum = new Forum($ForumId);

$ForumName = $Forum->ForumName();
$ModeratorId = $Forum->ModeratorId();

if (isset($_GET["MessageId"]))
{
    $MessageId = intval($_GET["MessageId"]);
    $Message = new Message($MessageId);
    $F_Subject = $Session->IsRegistered("F_Subject")
        ? $Session->Get("F_Subject") : $Message->Subject();
    $F_Body = $Session->IsRegistered("F_Body")
        ? $Session->Get("F_Body") : $Message->Body();
    $PosterId = $Message->PosterId();
    $IsUpdate = $Session->IsRegistered("IsUpdate")
        ? $Session->Get("IsUpdate") : False ;
}
else
{
    if (isset($_POST["F_Subject"]))
        $F_Subject = $_POST["F_Subject"];
    else
        $F_Subject = $Session->Get("F_Subject");

    if (isset($_POST["F_Body"]))
        $F_Body = $_POST["F_Body"];
    else
        $F_Body = $Session->Get("F_Body");
}

$Session->PassVariable("ForumId", $ForumId);
$Session->PassVariable("TopicId", $TopicId);

PageTitle("Post Message");
if (!CheckAuthorization( PRIV_POSTTOFORUMS )) {  return;  }

?>
