<?PHP

#
#   Axis--RSS.php
#   An Object to Support RSS 0.92 (Rich Site Summary) Output
#
#   Copyright 2002 Axis Data
#   This code is free software that can be used or redistributed under the
#   terms of Version 2 of the GNU General Public License, as published by the
#   Free Software Foundation (http://www.fsf.org).
#
#   Author:  Edward Almasy (almasy@axisdata.com)
#
#   Part of the AxisPHP library v1.2.5
#   For more information see http://www.axisdata.com/AxisPHP/
#

require_once("Axis--StandardLibrary.php");


class RSS {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    function RSS()
    {
        $this->ChannelCount = -1;
    }

    # required channel values
    function AddChannel($Title, $Link, $Description) 
    {  
        $this->ChannelCount++;
        $this->ItemCounts[$this->ChannelCount] = -1;
        $this->Channels[$this->ChannelCount]["Title"] = $Title;
        $this->Channels[$this->ChannelCount]["Link"] = $Link;  
        $this->Channels[$this->ChannelCount]["Description"] = $Description;  
    }
    function SetImage($Url, $Title, $Link, 
            $Height = NULL, $Width = NULL, $Description = NULL)
    {
        $this->Channels[$this->ChannelCount]["ImageUrl"] = $Url;
        $this->Channels[$this->ChannelCount]["ImageTitle"] = $Title;
        $this->Channels[$this->ChannelCount]["ImageLink"] = $Link;
        $this->Channels[$this->ChannelCount]["ImageHeight"] = $Height;
        $this->Channels[$this->ChannelCount]["ImageWidth"] = $Width;
        $this->Channels[$this->ChannelCount]["ImageDescription"] = $Description;
    }

    # optional channel values
    function SetLanguage($Value) {  $this->Channels[$this->ChannelCount]["Language"] = $Value;  }
    function SetCopyright($Value) {  $this->Channels[$this->ChannelCount]["Copyright"] = $Value;  }
    function SetManagingEditor($Value) {  $this->Channels[$this->ChannelCount]["ManagingEditor"] = $Value;  }
    function SetWebmaster($Value) {  $this->Channels[$this->ChannelCount]["Webmaster"] = $Value;  }
    function SetPicsRating($Value) {  $this->Channels[$this->ChannelCount]["PicsRating"] = $Value;  }
    function SetPublicationDate($Value) {  $this->Channels[$this->ChannelCount]["PublicationDate"] = $this->FormatDate($Value);  }
    function SetLastChangeDate($Value) {  $this->Channels[$this->ChannelCount]["LastChangeDate"] = $this->FormatDate($Value);  }
    function SetTextInput($Title, $Description, $Name) 
    {  
        $this->Channels[$this->ChannelCount]["TextInputTitle"] = $Title;
        $this->Channels[$this->ChannelCount]["TextInputDescription"] = $Description;
        $this->Channels[$this->ChannelCount]["TextInputName"] = $Name;
    }
    function SetSkipTimes($Days, $Hours)
    {
        # ???
    }
    function SetCloud($Domain, $Port, $Path, $Procedure, $Protocol)
    {
        # ???
    }

    # add item to channel
    function AddItem($Title = NULL, $Link = NULL, $Description = NULL)
    {
        $this->ItemCounts[$this->ChannelCount]++;
        $this->Items[$this->ChannelCount][$this->ItemCounts[$this->ChannelCount]]["Title"] = $Title;
        $this->Items[$this->ChannelCount][$this->ItemCounts[$this->ChannelCount]]["Link"] = $Link;
        $this->Items[$this->ChannelCount][$this->ItemCounts[$this->ChannelCount]]["Description"] = $Description;
    }
    function AddItemCategory($Category, $Url)
    {
        $this->Items[$this->ChannelCount][$this->ItemCounts[$this->ChannelCount]]["Category"] = $Category;
        $this->Items[$this->ChannelCount][$this->ItemCounts[$this->ChannelCount]]["CategoryUrl"] = $Url;
    }
    function AddItemEnclosure($Url, $Length, $Type)
    {
        $this->Items[$this->ChannelCount][$this->ItemCounts[$this->ChannelCount]]["EnclosureUrl"] = $Url;
        $this->Items[$this->ChannelCount][$this->ItemCounts[$this->ChannelCount]]["EnclosureLength"] = $Length;
        $this->Items[$this->ChannelCount][$this->ItemCounts[$this->ChannelCount]]["EnclosureType"] = $Type;
    }
    function AddItemSource($Source, $Url)
    {
        $this->Items[$this->ChannelCount][$this->ItemCounts[$this->ChannelCount]]["Source"] = $Source;
        $this->Items[$this->ChannelCount][$this->ItemCounts[$this->ChannelCount]]["SourceUrl"] = $Url;
    }

    # write out and RSS page
    function PrintRSS()
    {
        # print opening elements
        header("Content-type: text/xml");
        FTOut("<?xml version='1.0'?>");
        FTOut("<rss version='0.92'>", 0);

        # for each channel
        for ($this->ChannelIndex = 0;  $this->ChannelIndex <= $this->ChannelCount;  $this->ChannelIndex++)
        {
            # open channel element
            FTOut("<channel>");

            # print required channel elements
            $this->PrintChannelElement("Title", "title");
            $this->PrintChannelElement("Link", "link");
            $this->PrintChannelElement("Description", "description");

            # print image element (url, title, link required)
            FTOut("<image>");
            $this->PrintChannelElement("ImageUrl", "url");
            $this->PrintChannelElement("ImageTitle", "title");
            $this->PrintChannelElement("ImageLink", "link");
            $this->PrintChannelElement("ImageWidth", "width");
            $this->PrintChannelElement("ImageHeight", "height");
            $this->PrintChannelElement("ImageDescription", "description");
            FTOut("</image>");

            # print optional channel elements
            $this->PrintChannelElement("Language", "language");
            $this->PrintChannelElement("Copyright", "copyright");
            $this->PrintChannelElement("ManagingEditor", "managingEditor");
            $this->PrintChannelElement("Webmaster", "webMaster");
            $this->PrintChannelElement("PicsRating", "rating");
            $this->PrintChannelElement("PublicationDate", "pubDate");
            $this->PrintChannelElement("LastChangeDate", "lastBuildDate");
            # ???  STILL TO DO:  SkipDays, SkipHours, Cloud
            FTOut("<docs>http://backend.userland.com/rss092</docs>");

            # for each item in this channel
            for ($this->ItemIndex = 0;  $this->ItemIndex <= $this->ItemCounts[$this->ChannelCount];  $this->ItemIndex++)
            {
                # open item element
                FTOut("<item>");

                # print item elements
                $this->PrintItemElement("Title", "title");
                $this->PrintItemElement("Link", "link");
                $this->PrintItemElement("Description", "description");
                if ($this->Items[$this->ChannelIndex][$this->ItemIndex]["Category"] != NULL)
                {
                    FTOut("<category url='".$this->Items[$this->ChannelIndex][$this->ItemIndex]["CategoryUrl"]."'>");
                    FTOut($this->Items[$this->ChannelIndex][$this->ItemIndex]["Category"]);
                    FTOut("</category>");
                }
                if ($this->Items[$this->ChannelIndex][$this->ItemIndex]["EnclosureUrl"] != NULL)
                {
                    FTOut("<enclosure "
                        ."url='".$this->Items[$this->ChannelIndex][$this->ItemIndex]["EnclosureUrl"]."' "
                        ."length='".$this->Items[$this->ChannelIndex][$this->ItemIndex]["EnclosureLength"]."' "
                        ."type='".$this->Items[$this->ChannelIndex][$this->ItemIndex]["EnclosureType"]."' />");
                }
                if ($this->Items[$this->ChannelIndex][$this->ItemIndex]["Source"] != NULL)
                {
                    FTOut("<source url='".$this->Items[$this->ChannelIndex][$this->ItemIndex]["SourceUrl"]."'>");
                    FTOut($this->Items[$this->ChannelIndex][$this->ItemIndex]["Source"]);
                    FTOut("</source>");
                }

                # close item element
                FTOut("</item>");
            }
            
            # close channel element
            FTOut("</channel>");
        }

        # print closing elements
        FTOut("</rss>");
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $Channels;
    var $Items;
    var $ChannelCount;
    var $ItemCounts;
    var $ChannelIndex;
    var $ItemIndex;

    function PrintChannelElement($VarName, $TagName)
    {
        if ($this->Channels[$this->ChannelIndex][$VarName] != NULL)
        {
            FTOut("<${TagName}>"
                  .utf8_encode(htmlspecialchars(preg_replace("/[\\x00-\\x1F]+/", "", $this->Channels[$this->ChannelIndex][$VarName])))
                  ."</${TagName}>");
        }
    }
    function PrintItemElement($VarName, $TagName)
    {
        if ($this->Items[$this->ChannelIndex][$this->ItemIndex][$VarName] != NULL)
        {
            FTOut("<${TagName}>"
                  .utf8_encode(htmlspecialchars(preg_replace("/[\\x00-\\x1F]+/", "", $this->Items[$this->ChannelIndex][$this->ItemIndex][$VarName])))
                  ."</${TagName}>");
        }
    }
    
    function FormatDate($DateValue)
    {
        # convert date to timestamp
        $TimeStamp = strtotime($DateValue);
        
        # convert timestamp to properly-formatted date
        $DateString = date("r");
        
        # return properly-formatted date to caller
        return $DateString;
    }
}

# (FTOut == Formatted Tag Output)
function FTOut($String, $NewIndent = NULL)
{
    static $Indent = 0;

    $IndentSize = 4;

    # decrease indent if string contains end tag and does not start with begin tag
    if (preg_match("/<\/[A-Za-z0-9]+>/", $String) && !preg_match("/^<[^\/]+/", $String)) {  $Indent--;  }

    # reset indent if value is supplied
    if ($NewIndent != NULL) {  $Indent = $NewIndent;  }

    # print string
    print(substr("                                                                                                                        ",
            0, ($Indent * $IndentSize)).$String."\n");

    # inrease indent if string starts with begin tag and does not contain end tag
    if (preg_match("/^<[^\/]+/", $String) 
            && !preg_match("/<\/[A-Za-z0-9]+>/", $String)
            && !preg_match("/\/>$/", $String)) 
    {  
        $Indent++;  
    }
}


?>
