<?PHP

#
#   FILE:  SPT--AddClassification.php
#
#   FUNCTIONS PROVIDED:
#       PrintParentId()
#           - print ID of classification under which to add new classification
#       PrintLocation()
#           - print string with hierarchy above new classification
#       PrintClassificationTypeId()
#           - print the ClassTypeId
#       PrintClassificationTypeName()
#           - print the ClassTypeName
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       ParentId
#           - ID of classification under which to add new classification 
#                   (-1 if add at top of hierarchy)
#       ClassTypeId
#           - classification type ID of classification to be added
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--Classification.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--Qualifier.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print ID of classification under which to add new classification
function PrintParentId()
{
    global $ParentClass;
    print($ParentClass->Id());
}

# print string with hierarchy above new classification
function PrintLocation()
{
    global $ParentId;
    global $ParentClass;

    if ($ParentId == -1)
    {
        print("(top)");
    }
    else
    {
        print($ParentClass->FullName());
    }
}

# print the ClassTypeId
function PrintClassificationTypeId()
{
    global $HTTP_GET_VARS;

    $ClassTypeId = $HTTP_GET_VARS["ClassTypeId"];

    print($ClassTypeId);
}

# print the ClassTypeName
function PrintClassificationTypeName()
{
    global $HTTP_GET_VARS;

    $ClassTypeId = $HTTP_GET_VARS["ClassTypeId"];

    print(GetClassTypeName($ClassTypeId));
}

# function to determine if field has itemlevelqualifiers or not
function UsesQualifiers()
{
    $Schema = & new MetadataSchema();
    $Field = $Schema->GetFieldByName("Classification");

    return $Field->UsesQualifiers();
}

# print Qualifier option list
function PrintQualifierList()
{
    $Schema = & new MetadataSchema();
    $Field = $Schema->GetFieldByName("Classification");

    if($Field->HasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        PrintOptionList("F_QualifierId", $Items, $Field->DefaultQualifier(),
            0, 1, NULL, false);
    }
    else if($Field->DefaultQualifier() > 0)
    {
        $Qualifier = & new Qualifier($Field->DefaultQualifier());
        if(is_object($Qualifier))
            print $Qualifier->Name();
    }
    else
        print "None";
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_CLASSADMIN);

# look up parent class info
$ParentId = $HTTP_GET_VARS["ParentId"];
$ParentClass = new Classification($ParentId);

$NavDirCorrection = "../";
include("include/SPT--StandardHtmlPageLoad.php");

$Session->UnregisterVariable("ErrorMessages");

?>
