<?php
#
#   FILE:  SPT--AddNewControlledNameComplete.php
#
#   FUNCTIONS PROVIDED:
#       PrintAddedControlledNames()
#           - displays added controlled names and variants 
#
#   FUNCTIONS EXPECTED:
#           - none
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--ResourceFactory.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintAddedControlledName()
{
    global $HTTP_POST_VARS;

    $F_ControlledName = $HTTP_POST_VARS["F_ControlledName"];
    $F_Variant = $HTTP_POST_VARS["F_Variant"];

    print $F_ControlledName;
    if(!empty($F_Variant))
        print ", Variant (".$F_Variant.")";
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function AddControlledName()
{
    global $Session;
    global $DisplayString;
    global $HTTP_POST_VARS;
    global $ResourceId;
    global $AddedNames;
    global $Variants;

    $DB =& new SPTDatabase();

    $F_ControlledName = $HTTP_POST_VARS["F_ControlledName"];
    $F_ControlledNameTypeId = $HTTP_POST_VARS["F_ControlledNameTypeId"];
    $F_Variant = $HTTP_POST_VARS["F_Variant"];
    $F_Qualifier = $HTTP_POST_VARS["F_Qualifier"];

    # set "--" to NULL
    if(is_null($F_Qualifier) || $F_Qualifier == "--")
        $F_Qualifier = "NULL";

    if((is_null($F_ControlledName) || empty($F_ControlledName))
        && $F_Variant != NULL)
    {
        $Session->PassVariable("ErrorMessage",
            "Error: ControlledName is a required field. ".
            "Please Select Back and correct the problem.");
        PrintAutoRefreshPage("Error Message", "SPT--DisplayError.php");     
        exit;
    }
    else
    {
        $F_ControlledName = addslashes(trim($F_ControlledName));
        if(!empty($F_ControlledName))
        {
            # check to see if it already exists
            $Query = "Select * from ControlledNames where ".
                "ControlledName = \"".$F_ControlledName."\"".
                " and ControlledNameTypeId = ".$F_ControlledNameTypeId;
#            echo "Query=$Query<br>";
            $DB->Query($Query);
            if($DB->NumRowsSelected() > 0)
            {
                $Session->PassVariable("ErrorMessage",
                    "Error: ControlledName '".$F_ControlledName.
                    "' already exists.<br>".
                    "Please Select Back and correct the problem.");
                    PrintAutoRefreshPage("Error Message",
                        "SPT--DisplayError.php");     
                exit;
            }
                
            $Query = "Insert into ControlledNames ".
                "(ControlledName, ControlledNameTypeId, QualifierId) ".
                "values (\"$F_ControlledName\", ".
                "$F_ControlledNameTypeId, $F_Qualifier)";
#            echo "Query=$Query<br>";
            $DB->Query($Query);

            $ControlledNameId = $DB->LastInsertId("ControlledNames");
            $F_Variant = trim($F_Variant);
            if(!empty($F_Variant))
            {
                $Query = "Insert into VariantNames ".
                    "(ControlledNameId, VariantName) ".
                    "values ($ControlledNameId, \"$F_Variant\") ";
#                echo "Query=$Query<br>";
                $DB->Query($Query);
            }

            if(!empty($ResourceId))
            {
                $Query = "INSERT into ResourceNameInts set ".
                    "ResourceId = $ResourceId, ".
                    "ControlledNameId = $ControlledNameId";

                $DB->Query($Query);
            }
        }
    }
}    

# ----- MAIN -----------------------------------------------------------------

$NavDirCorrection = "../";
CheckAuthorization(PRIV_NAMEADMIN);

# get currently edited resource
$RFactory = & new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

if(substr($Submit, 0, 7) == "Add New")
    AddControlledName();
else
{
    $F_Variant = $HTTP_POST_VARS["F_Variant"];
    $F_ControlledName = $HTTP_POST_VARS["F_ControlledName"];
    $F_ControlledNameTypeId = $HTTP_POST_VARS["F_ControlledNameTypeId"];
    $Session->PassVariable("F_Variant", $F_Variant);
    $Session->PassVariable("F_ControlledName", $F_ControlledName);
    $Session->PassVariable("F_ControlledNameTypeId", $F_ControlledNameTypeId);
    PrintAutoRefreshPage("Add Controlled Names", "SPT--AddControlledName.php");
    exit;
}

#  <0 = temporary resource, >0 = existing resource
if($ResourceId != 0)
{
    PrintAutoRefreshPage("Add New Resource", "SPT--DBEntry.php");
    exit;
}
# just added new controlled name
else
{
    PageTitle("Add Controlled Name Complete");
    include("include/SPT--StandardHtmlPageLoad.php");
}

?>
