<?php
#
#   FILE:  SPT--EditControlledNameComplete.php
#
#   FUNCTIONS PROVIDED:
#       DisplayControlledNameInfo()
#           - updates or deletes ControlledName fields from ControlledNames
#             and VariantNames, and updates DateLastModified for affected
#             Resources
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function DisplayControlledNameInfo()
{
    global $SubmitResult;
    global $HTTP_POST_VARS;

    $SubmitResult = $HTTP_POST_VARS["SubmitResult"];

    $DB =& new SPTDatabase();

    $Check = 0;
    reset($HTTP_POST_VARS);
    # we assume that ControlledNameId comes before ControlledName
    while (list($var, $val) = each ($HTTP_POST_VARS))
    {
        # default QualifierId to NULL
        $QualifierId = "NULL";
        if(ereg("^F_Check_([0-9]+)",$var,$regs))
        {
            $Check = 1;
            continue;
        }
        if(ereg("^F_ControlledNameId_([0-9]+)",$var,$regs))
        {
            $ControlledNameId = $val;
            continue;
        }
        if(ereg("^F_ControlledName_([0-9]+)",$var,$regs))
        {
            $ControlledName = $val;
            continue;
        }
        if(ereg("^F_VariantName_([0-9]+)",$var,$regs))
        {
            $VariantName = $val;
            continue;
        }
        if(ereg("^F_ControlledNameTypeId_([0-9]+)",$var,$regs))
        {
            $ControlledNameTypeId = $val;
            $Type = GetControlledNameType($ControlledNameTypeId);
            $Schema = & new MetadataSchema();
            $Field = $Schema->GetFieldByName($Type);
            if($Field->HasItemLevelQualifiers())
                continue;
        }
        if(ereg("^F_QualifierName_([0-9]+)",$var,$regs))
        {
            $QualifierId = $val;
            # if "--" selected, set qualifier id = NULL
            if($QualifierId == "--")
                $QualifierId = "NULL";
        }
        $VariantName = addslashes(trim($VariantName));
        $ControlledName = addslashes(trim($ControlledName));

        if(!empty($ControlledName) && 
            $SubmitResult == "Update Checked Records" && $Check)
        {
            $Query = "Update ControlledNames set ".
                        "ControlledName = \"$ControlledName\", ".
                        "ControlledNameTypeId=$ControlledNameTypeId, ".
                        "QualifierId=$QualifierId ".
                        "where ControlledNameId = $ControlledNameId";

            $DB->Query($Query);

            # update require_once("include/SPT--Common.php");
            if(!empty($VariantName))
            {
                # see if variant name exists for the controlled Name
                $Query = "SELECT * from VariantNames WHERE ".
                            "ControlledNameId = $ControlledNameId";
                $DB->Query($Query);

                # variant name exists so do an update
                if($DB->NumRowsSelected() > 0)
                {
                    $Query = "UPDATE VariantNames set ".
                            "VariantName = \"$VariantName\" WHERE ".
                            "ControlledNameId = $ControlledNameId";
                    $DB->Query($Query);
                }
                # no variant name so do an insert
                else
                {
                    $Query = "INSERT into VariantNames ".
                            "(VariantName, ControlledNameId) VALUES ".
                            "(\"$VariantName\",$ControlledNameId)";
                    $DB->Query($Query);
                }
               
            }
            # delete variant name
            else
            {
                $Query = "Delete from VariantNames where ".
                    "ControlledNameId = $ControlledNameId";
                $DB->Query($Query);
            }
        }
           
        # delete from ControlledNames and VariantNames
        else if($SubmitResult == "Delete Checked Records" && $Check)
        {
            $Query = "Delete from ControlledNames where ".
                    "ControlledNameId = $ControlledNameId";
            $DB->Query($Query);

            $Query = "Delete from VariantNames where ".
                    "ControlledNameId = $ControlledNameId";
            $DB->Query($Query);
        }

        # now update all affected Resources        
        if($Check)
        {
            $Query =
                "Select distinct Resources.ResourceId, Title from ".
                "Resources INNER JOIN ResourceNameInts ON ".
                "ResourceNameInts.ResourceId=Resources.ResourceId ".
                "WHERE ControlledNameId = $ControlledNameId ".
                "ORDER BY Resources.ResourceId";

            $DB->Query($Query);
                
            $Rows=$DB->NumRowsSelected();
            for($i=0; $i<$Rows; $i++)
            {
                $Result = $DB->FetchNextRowArray();
                print "<a href=\"../SPT--FullRecord.php?ResourceId=".
                    "$Result[ResourceId]\" target=\"_blank\">".
                    "$Result[Title]</a><br>\n";
                $UpdateQuery[$i] = "Update Resources set ".
                    "DateLastModified = '".date("Y-m-d H:i:s").
                    "' where ResourceId = $Result[ResourceId]";
            }
            for($i=0;$i<$Rows;$i++)
            {
                $DB->Query($UpdateQuery[$i]);
            }
        }
        $Check = 0;
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_NAMEADMIN);
PageTitle("Edit Controlled Name Complete");
$NavDirCorrection = "../";
include("include/SPT--StandardHtmlPageLoad.php");


?>
