<?php
#
#   FILE:  SPT--EditControlledName.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Qualifier.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--ResourceFactory.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to print display string
function PrintDisplayString()
{
    global $DisplayString;

    print $DisplayString;
}

# function to return if Existing Resource Record or Not
function ExistingResource()
{
    global $ResourceId;

    return ($ResourceId > 0) ? true : false;
}

# function to print the index value
function PrintIndex()
{
    global $Index;

    print $Index;
}

# functon to print the ControlledName
function PrintControlledName()
{
    global $ControlledName;

    print $ControlledName;
}

# returns true if field uses qualifiers
function  FieldUsesQualifiers()
{
    global $DefaultTypeId;

    $Schema = & new MetadataSchema();
    $Name = GetControlledNameType($DefaultTypeId);
    $Field = $Schema->GetFieldByName($Name);
    return $Field->UsesQualifiers();
}

# returns true if field uses item level qualifiers
function FieldHasItemLevelQualifiers()
{
    global $DefaultTypeId;

    $Schema = & new MetadataSchema();
    $Name = GetControlledNameType($DefaultTypeId);
    $Field = $Schema->GetFieldByName($Name);
    return $Field->HasItemLevelQualifiers();
}

# return default qualifier
function FieldDefaultQualifier()
{
    global $DefaultTypeId;

    $Schema = & new MetadataSchema();
    $Name = GetControlledNameType($DefaultTypeId);
    $Field = $Schema->GetFieldByName($Name);
    return $Field->DefaultQualifier();
}

# function to print the Qualifier 
function PrintQualifierName()
{
    global $QualifierId;

    # only print if it exists
    if(FieldUsesQualifiers())
    {
        if(is_null($QualifierId))
            $QualifierId = FieldDefaultQualifier();
        $Qualifier = & new Qualifier($QualifierId);
        if(is_object($Qualifier))
            print " (".$Qualifier->Name().")";
    }
}

# function to print list of qualifiers
function PrintQualifierOrList()
{
    global $DefaultTypeId;

    $Schema = & new MetadataSchema();
    $Name = GetControlledNameType($DefaultTypeId);
    $Field = $Schema->GetFieldByName($Name);

    if(FieldHasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);
        PrintOptionList("F_Qualifier", $Items, NULL, 0, 1, NULL, false);
        
   }
    else
    {
        $QualifierId = FieldDefaultQualifier();
        PrintQualifierName();
    }
}

# function to print the ControlledNameId
function PrintControlledNameId()
{
    global $ControlledNameId;

    print $ControlledNameId;
}

# return if true if DefaultTypeId specified, else false
function DefaultTypeIdSet()
{
    global $DefaultTypeId;

    return ($DefaultTypeId != 0) ? true : false; 
}

# print DefaultTypeId
function PrintDefaultTypeId()
{
    global $DefaultTypeId;

    print $DefaultTypeId;
}

# function to print out if ControlledNames found
function ControlledNamesExist()
{
    global $NumRows;

    return $NumRows;
}

# function to see if Form variable F_ControlledName is empty or not
function SearchEntered()
{
    global $F_ControlledName;

    return (empty($F_ControlledName)) ? false : true;
}

# display found controlled names
function DisplayFoundControlledNames()
{
    global $HTTP_POST_VARS;
    global $F_ControlledName;
    global $DB;
    global $DisplayString;
    global $TypeString;
    global $DefaultTypeId;
    global $ResourceId;
    global $Index;
    global $ControlledName;
    global $ControlledNameId;
    global $QualifierId;
    global $NumRows;

    trim($F_ControlledName);
    if ($F_ControlledName)
    {
        $F_ControlledName = addslashes($F_ControlledName);

        # replace * and space with wild cards
        # pass +, squiqgles, and brackets through as literals
        # so that REGEXP in query doesn't puke
        $ControlledName = str_replace(" ", ".*.", $F_ControlledName);       
        $ControlledName = str_replace("{", "[{]", $ControlledName);       
        $ControlledName = str_replace("}", "[}]", $ControlledName);       
        $ControlledName = str_replace("(", "[(]", $ControlledName);       
        $ControlledName = str_replace(")", "[)]", $ControlledName); 
        $ControlledName = str_replace("*", ".*.", $ControlledName);
        $ControlledName = str_replace("+", "[+]", $ControlledName);
         
        # this query gets us close
        $query = "Select ControlledName, C.ControlledNameId, ".
                "ControlledNameTypeId, QualifierId from ControlledNames AS C ".
                "LEFT JOIN VariantNames ".
                "AS V ON C.ControlledNameId=V.ControlledNameId WHERE (".
                "ControlledName REGEXP \"$ControlledName\" OR ".
                "VariantName REGEXP \"$ControlledName\") ".
                "AND ControlledNameTypeId = ".$DefaultTypeId." ".
                "ORDER BY ControlledName";

#       echo "query=$query<br>";
    
        $DB->Query("$query");
        $NumRows = $DB->NumRowsSelected();
        $Index=0;
      
        if ($NumRows)
        {
            DisplayHeading();
            while($Index < $DB->NumRowsSelected())
            {
                $Result = $DB->FetchNextRowArray();
                $ControlledName = $Result["ControlledName"];
                $ControlledNameId = $Result["ControlledNameId"];
                $QualifierId = $Result["QualifierId"];
                DisplayControlledNameSelection();
                $Index++;
            }
            DisplayAddButtons();           
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN);

$Submit = $HTTP_POST_VARS["Submit"];

if(isset($HTTP_GET_VARS["DefaultTypeId"]))
    $DefaultTypeId = $HTTP_GET_VARS["DefaultTypeId"];
else
    $DefaultTypeId = $Session->Get("DefaultTypeId");

$F_ControlledName = $HTTP_POST_VARS["F_ControlledName"];

if($DefaultTypeId > 0)
    $DisplayString = GetControlledNameType($DefaultTypeId);
else
    $DisplayString = "Controlled Name";

PageTitle("Assign/Add ".$DisplayString."s");

$RFactory = & new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();
$Session->PassVariable("DefaultTypeId", $DefaultTypeId);

# handle Cancel button
if($Submit == "Cancel")
{
    PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
    exit;
}
    
$NavDirCorrection = "../";

include("include/SPT--StandardHtmlPageLoad.php");

?>
