<?PHP

#
#   FILE:  SPT--ConfirmDeleteQualifier.php
#
#   FUNCTIONS PROVIDED:
#       PrintQualifierName()
#       - print out topic name 
#
#       PrintForumName()
#       - print out forum name 
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#
require_once("include/SPT--Common.php");
require_once("include/SPT--Qualifier.php");
PageTitle("Confirm Delete Qualifier");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintQualifierNames()
{
    global $Qualifiers;

    foreach($Qualifiers as $QualifierId)
    {
        $Qualifier =& new Qualifier($QualifierId);
        $QualifierName = $Qualifier->Name();
        print $QualifierName."<br>";
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# grab entry information from database
$DB =& new SPTDatabase();

$Qualifiers = $Session->Get("Qualifiers");
$Session->PassVariable("Qualifiers", $Qualifiers);

include("include/SPT--StandardHtmlPageLoad.php");

?>
