<?PHP

#
#   FILE:  SPT--ConfirmDeleteTopic.php
#
#   FUNCTIONS PROVIDED:
#       PrintTopicName()
#       - print out topic name 
#
#       PrintForumName()
#       - print out forum name 
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#
require_once("include/SPT--Common.php");
require_once("include/SPT--Forum.php");
require_once("include/SPT--Topic.php");
PageTitle("Confirm Delete Topic");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintTopicName()
{
    global $TopicName;

    print $TopicName;
}

function PrintForumName()
{
    global $ForumName;

    print $ForumName;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# grab entry information from database
$DB =& new SPTDatabase();

$TopicId = $Session->Get("topicid");
$Topic =& new Topic($TopicId);
$TopicName = $Topic->TopicName();

$ForumId = $Session->Get("forumid");
$Forum =& new Forum($ForumId);
$ForumName = $Forum->ForumName();

$Session->PassVariable("forumid", $ForumId);
$Session->PassVariable("topicid", $TopicId);

include("include/SPT--StandardHtmlPageLoad.php");

?>
