<?PHP

#
#   FILE:  SPT--EditSysConfig.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# functions to return sys config info (for insertion into forms)
function PrintPortalName() {  PrintValue("PortalName");  }
function PrintAdminEmail() {  PrintValue("AdminEmail");  }
function PrintNumClassesPerBrowsePage() {  PrintValue("NumClassesPerBrowsePage");  }
function PrintNumAnnounceOnHomePage() {  PrintValue("NumAnnounceOnHomePage");  }
function PrintNumResourcesOnHomePage() {  PrintValue("NumResourcesOnHomePage");  }
function PrintLegalNotice() { PrintValue("LegalNotice"); }
function PrintCheckedIfSearchTermHandlingIsAnd()
{
    global $SysConfig;
    if ($SysConfig->SearchTermsRequired()) {  print("checked");  }
}
function PrintCheckedIfSearchTermHandlingIsOr()
{
    global $SysConfig;
    if (!$SysConfig->SearchTermsRequired()) {  print("checked");  }
}
function PrintCheckedIfAnnouncementsEnabled()
{
    global $SysConfig;
    if ($SysConfig->AnnouncementsEnabled()) {  print("checked");  }
}
function PrintCheckedIfAnnouncementsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->AnnouncementsEnabled()) {  print("checked");  }
}
function PrintCheckedIfForumsEnabled()
{
    global $SysConfig;
    if ($SysConfig->ForumsEnabled()) {  print("checked");  }
}
function PrintCheckedIfForumsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->ForumsEnabled()) {  print("checked");  }
}
function PrintCheckedIfAllowMultipleUIsEnabled()
{
    global $SysConfig;
    if ($SysConfig->AllowMultipleUIsEnabled()) {  print("checked");  }
}
function PrintCheckedIfAllowMultipleUIsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->AllowMultipleUIsEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceLaunchesNewWindowEnabled()
{
    global $SysConfig;
    if ($SysConfig->ResourceLaunchesNewWindowEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceLaunchesNewWindowDisabled()
{
    global $SysConfig;
    if (!$SysConfig->ResourceLaunchesNewWindowEnabled()) {  print("checked");  }
}
function PrintCheckedIfUserAgentsEnabled()
{
    global $SysConfig;
    if ($SysConfig->UserAgentsEnabled()) {  print("checked");  }
}
function PrintCheckedIfUserAgentsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->UserAgentsEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceRatingsEnabled()
{
    global $SysConfig;
    if ($SysConfig->ResourceRatingsEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceRatingsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->ResourceRatingsEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceCommentsEnabled()
{
    global $SysConfig;
    if ($SysConfig->ResourceCommentsEnabled()) {  print("checked");  }
}
function PrintCheckedIfResourceCommentsDisabled()
{
    global $SysConfig;
    if (!$SysConfig->ResourceCommentsEnabled()) {  print("checked");  }
}
function PrintCheckedIfSearchDBEnabled()
{
    global $SysConfig;
    if ($SysConfig->SearchDBEnabled()) {  print("checked");  }
}
function PrintCheckedIfSearchDBDisabled()
{
    global $SysConfig;
    if (!$SysConfig->SearchDBEnabled()) {  print("checked");  }
}
function PrintCheckedIfRecommenderDBEnabled()
{
    global $SysConfig;
    if ($SysConfig->RecommenderDBEnabled()) {  print("checked");  }
}
function PrintCheckedIfRecommenderDBDisabled()
{
    global $SysConfig;
    if (!$SysConfig->RecommenderDBEnabled()) {  print("checked");  }
}
function PrintCheckedIfReleaseFlagApproved()
{
    global $SysConfig;
    if ($SysConfig->ReleaseFlagApproved()) {  print("checked");  }
}
function PrintCheckedIfReleaseFlagNotApproved()
{
    global $SysConfig;
    if (!$SysConfig->ReleaseFlagApproved()) {  print("checked");  }
}

function PrintActiveUIOptionList()
{
    global $SysConfig;

    # print option list for UI
    print(GetActiveUIOptionList($SysConfig->DefaultActiveUI()));
}

function PrintThemeOptionList()
{
    global $SysConfig;

    # print option list for UI
    print(GetThemeOptionList($SysConfig->CurrentTheme()));
}

function PrintAboutText() { PrintValue("AboutText"); }

function IsOkayToDisplayThemeSelection() 
{  
    global $SysConfig;
    return ($SysConfig->DefaultActiveUI() == "SPTUI--CWIS") ? TRUE : FALSE;
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function PrintValue($ValueName)
{
    global $SysConfig;  
    global $Session;

    $FormVar = "F_".$ValueName;
    ${$FormVar} = $Session->Get($FormVar);
    if (isset(${$FormVar}))
    {
        print(${$FormVar});
        $Session->UnregisterVariable($FormVar);
    }
    else
    {
        print($SysConfig->{$ValueName}());  
    }
}


# ----- MAIN -----------------------------------------------------------------

PageTitle("Edit System Configuration");
CheckAuthorization(PRIV_SYSADMIN);

include("include/SPT--StandardHtmlPageLoad.php");


?>
