<?php

#
#   FILE:  SPT--ImportUsersExecute.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# init variables -- first time thru they will be null
function InitImportVars()
{
    global $ImportComplete, $FSeek, $UserCount;

    if(is_null($ImportComplete))
        $ImportComplete = 0;
    if(is_null($FSeek))
        $FSeek = 0;
    if(is_null($UserCount))
        $UserCount = 0;
}

# do/while loop, this is the main event
function DoWhileLoop()
{
    global $DB, $fp, $Session, $FSeek, $Title, $ImportComplete;
    global $User, $UserCount, $LineCount;

    $LineCount = 0;

    while (!feof($fp) && $LineCount < 500 && $ImportComplete == 0)
    {
        # read in line from import file
        $fline = fgets($fp, 4096);

#        echo "fline=$fline<br>";
    
        # update variables 
        $LineCount++;
        $Session->PassVariable("LineCount", $LineCount);
        $FSeek += strlen($fline);
        $Session->PassVariable("FSeek", $FSeek);

        $Value = NULL;    
        # parse line from import file
        $Vars = explode("\t", $fline);

        # initial the vars
        $UserName = $Vars[0];
        $UserPassword = $Vars[1];
        $Email = $Vars[2];
        $Website = $Vars[3];
        $RealName = $Vars[4];
        $Address1 = $Vars[5];
        $Address2 = $Vars[6];
        $City = $Vars[7];
        $State = $Vars[8];
        $Country = $Vars[9];
        $Zipcode = $Vars[10];

        # default UserPassword to UserName if blank
        if(empty($UserPassword))
            $UserPassword = $UserName;

        # encrypt the password
        $UserPassword = crypt($UserPassword);

        # bail out if line was empty or end of file encountered
        if(is_null($UserName) || feof($fp))
        {
            break;
        }

        $query = "Insert into APUsers (".
                        "UserName, ".
                        "UserPassword, ".
                        "CreationDate, ".
                        "Email, ".
                        "Website, ".
                        "RealName, ".
                        "AddressLineOne, ".
                        "AddressLineTwo, ".
                        "City, ".
                        "State, ".
                        "Country, ".
                        "Zipcode, ".
                        "ActiveUI)".
                " Values (\"$UserName\", ".
                         "\"$UserPassword\", ".
                         "\"".strftime("%Y-%m-%d")."\", ".
                         "\"$Email\", ".
                         "\"$Website\", ".
                         "\"$RealName\", ".
                         "\"$Address1\", ".
                         "\"$Address2\", ".
                         "\"$City\", ".
                         "\"$State\", ".
                         "\"$Country\", ".
                         "\"$Zipcode\", ".
                         "\"SPTUI--Default\")";
    
#       echo "Query=".$query."<br>";

        $DB->Query($query);
    
        # keep track of number of resources added
        $UserCount++;
        $Session->PassVariable("UserCount", $UserCount);
    }
}

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

$DB =& new SPTDatabase();
$ClassDB =& new SPTDatabase();

InitImportVars();

# check for Cancel button
if($HTTP_POST_VARS["Submit"] == "Cancel")
{
    $ImportComplete = 1;
}

# register some key variables for other html code
$Session->PassVariable("ImportComplete", $ImportComplete);

# open import file for reading
$fp = fopen($HTTP_POST_VARS["F_FileName"], "r");

# echo "FSeek=$FSeek, FileName=$F_FileName<br>";

# seek to the next line
if($FSeek > 0)
{
    fseek($fp, $FSeek);
}

# the main work happenes here
DoWhileLoop();

# end of file reached?
if(feof($fp) || $ImportComplete)
{
    $ImportComplete = 1;
}
$Session->PassVariable("ImportComplete", $ImportComplete);
$Session->PassVariable("UserCount", $UserCount);

#  Time to auto-refresh?
if($ImportComplete == 0)
{
    $AutoRefreshToPage = "SPT--ImportDataExecute.php";
}

PageTitle("Import Users");
include("include/SPT--StandardHtmlPageLoad.php");

fclose($fp);

?>
