<?php
#
#   FILE:  SPT--UpdateQualifier.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--QualifierFactory.php");
require_once("include/SPT--Qualifier.php");
require_once("include/SPT--ResourceFactory.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# get list of qualifiers to remove
function GetRemoveList()
{
    global $HTTP_POST_VARS;

    $Schema = & new MetadataSchema();

    while (list($Var, $Value) = each ($HTTP_POST_VARS))
    {
        if(ereg("qid_([0-9]+)", $Var, $Regs))
        {
            if($Value != "")
            { 
                $Qualifiers[] = $Value;
            }
        }
    }
    return $Qualifiers;
}

# remove list value
function RemoveListValue()
{
    global $Session;

    $Schema = & new MetadataSchema();
    $RFactory = & new ResourceFactory();

    $Qualifiers = $Session->Get("Qualifiers");
            
    foreach($Qualifiers as $QualifierId)
    { 
        $Qualifier = & new Qualifier($QualifierId);
        $Schema->RemoveQualifierAssociations($Qualifier);
        $RFactory->ClearQualifier($Qualifier);
        $Qualifier->Delete();
    }
}

# add list value
function AddListValue()
{
    global $ErrorMessages;
    global $Session;
    global $F_NewName;
    global $F_NewNamespace;
    global $F_NewUrl;

    $QualifierFactory = & new QualifierFactory();

    # escape quotes
    $F_NewName = addslashes($F_NewName);
    $F_NewNamespace = addslashes($F_NewNamespace);
    $F_NewUrl = addslashes($F_NewUrl);
    
    # first check to see if it already exists
    if(!empty($F_NewName))
    {
        if($QualifierFactory->QualiferNameIsInUse($F_NewName))
        {
            $ErrorMessages[] = "<b>Error: </b>".$F_NewName." already exists";
            return;
        }

        # create new qualifier
        $Qualifier = & new Qualifier();
        $Qualifier->Name($F_NewName);
        $Qualifier->Namespace($F_NewNamespace);
        $Qualifier->Url($F_NewUrl);
    }
    else
        $ErrorMessages[] = "<b>Error: </b>No Value Entered";
}

# update list value
function UpdateListValue()
{
    global $HTTP_POST_VARS, $DB;

    while (list($Var, $Value) = each ($HTTP_POST_VARS))
    {
        if(ereg("qid_([0-9]+)", $Var, $Regs))
        {
            if(isset($Value))
                $QualifierId = $Value;
            else
                continue;
        }
        if(ereg("qn_([0-9]+)", $Var, $Regs))
        {
            if(isset($Value))
                $QualifierName = addslashes($Value);
            else
                continue;
            # add check here to see if it already exists
        }
        if(ereg("qs_([0-9]+)", $Var, $Regs))
        {
            if(isset($Value))
                $QualifierNamespace = addslashes($Value);
            else
                continue;
            # add check here to see if it already exists
        }
        if(ereg("qu_([0-9]+)", $Var, $Regs))
        {
            $Value = trim($Value);
            $QualifierUrl = addslashes($Value);
            if(!empty($QualifierName) && isset($QualifierId))
            { 
                # create new qualifier
                $Qualifier = & new Qualifier($QualifierId);
                $Qualifier->Name($QualifierName);
                $Qualifier->Namespace($QualifierNamespace);
                $Qualifier->Url($QualifierUrl);
                $QualifierId = NULL;
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN);

# grab entry information from database
$DB =& new SPTDatabase();

$F_NewName = $HTTP_POST_VARS["F_NewName"];
$F_NewNamespace = $HTTP_POST_VARS["F_NewNamespace"];
$F_NewUrl = $HTTP_POST_VARS["F_NewUrl"];
$OkayToDelete = $HTTP_POST_VARS["OkayToDelete"];
$Submit = $HTTP_POST_VARS["Submit"];

# check for Cancel button from previous screen
if($Submit == "Cancel")
{
    # cancel from confirm delete
    if($OkayToDelete)
        PrintAutoRefreshPage("Add/Edit Qualifiers", "SPT--AddQualifier.php");
    else
        PrintAutoRefreshPage("System Administration", "SPT--SysAdmin.php");
    exit;
}
else if(substr($Submit, 0, 6) == "Delete")
{
    if($OkayToDelete) 
    {
        RemoveListValue();
    }
    # give user a second chance
    else
    {
        $Qualifiers = GetRemoveList();
        if(count($Qualifiers) > 0)
        {
            $Session->PassVariable("Qualifiers", $Qualifiers);
            PrintAutoRefreshPage("Add Topic",
                "SPT--ConfirmDeleteQualifier.php");
            exit;
        }
        else
            $ErrorMessages[] = "<b>Error: </b>No Qualifiers selected";

    }
}
else if(substr($Submit, 0, 15) == "Update Selected")
{
    UpdateListValue();
}
else if(substr($Submit, 0, 3) == "Add" ||
    (empty($Submit) && isset($F_NewName)))
{
    AddListValue();
}

$Session->PassVariable("ErrorMessages");
PrintAutoRefreshPage("Add/Edit Qualifiers", "SPT--AddQualifier.php");

?>
