-- add Image to available metadata field types
ALTER TABLE MetadataFields CHANGE COLUMN FieldType FieldType ENUM("Text", "Number", "Date", "TimeStamp", "Paragraph", "Flag", "Tree", "ControlledName", "Option", "User", "Image");
ALTER TABLE MetadataFields ADD COLUMN MaxHeight INT;
ALTER TABLE MetadataFields ADD COLUMN MaxWidth INT;
ALTER TABLE MetadataFields ADD COLUMN MaxPreviewHeight INT;
ALTER TABLE MetadataFields ADD COLUMN MaxPreviewWidth INT;
ALTER TABLE MetadataFields ADD COLUMN MaxThumbnailHeight INT;
ALTER TABLE MetadataFields ADD COLUMN MaxThumbnailWidth INT;
ALTER TABLE MetadataFields ADD COLUMN DefaultAltText TEXT;

-- add fields and entries for "Screenshot" image metadata field
ALTER TABLE Resources ADD COLUMN ScreenshotAltText TEXT;
ALTER TABLE Resources ADD COLUMN ScreenshotFormat INT;
INSERT INTO MetadataFields (FieldName, FieldType, RequiredBySPT, Enabled, Optional, AllowMultiple, IncludeInKeywordSearch, IncludeInAdvancedSearch, TextFieldSize, MaxLength, ParagraphRows, ParagraphCols, DefaultValue, MinValue, MaxValue, FlagOnLabel, FlagOffLabel, DateFormat, SearchWeight, Description, DefaultAltText, MaxHeight, MaxWidth, MaxPreviewHeight, MaxPreviewWidth, MaxThumbnailHeight, MaxThumbnailWidth) VALUES ('Screenshot',             'Image',            0,1,1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,   '','',NULL,NULL, "An image containing a window snapshot of the resource.", "Screenshot", 768, 576, 100, 100, 50, 50);

-- add user interface style configuration table
CREATE TABLE UIStyleConfiguration (
    StyleName                   TEXT,
    LogoFileName                TEXT,
    LogoAltText                 TEXT,
    LogoWidth                   INT,
    LogoHeight                  INT,
    PageCenterBackground        TEXT,
    PageSideBackground          TEXT,
    SPTTableHeaderBackground    TEXT,
    MDTTableHeaderBackground    TEXT,
    TableBodyBackground         TEXT,
    ForumDarkHeaderBackground   TEXT,
    ForumLightHeaderBackground  TEXT,
    ForumBodyBackground         TEXT,
    NavBoxBackground            TEXT,
    HomeBoxBackground           TEXT
);
INSERT INTO UIStyleConfiguration (
        StyleName,
        PageCenterBackground, 
        PageSideBackground, 
        SPTTableHeaderBackground, 
        MDTTableHeaderBackground, 
        TableBodyBackground, 
        ForumDarkHeaderBackground, 
        ForumLightHeaderBackground, 
        ForumBodyBackground,
        NavBoxBackground,
        HomeBoxBackground
    ) VALUES (
        'SPTUI--Default',
        '#FFFFFF',
        '#EEEEEE',
        '#DDEEFF',
        '#DDFFDD',
        '#F5F5F5',
        '#000066',
        '#336699',
        '#EEEEEE',
        '#F8F8F8',
        '#F0F0F0'
    );

# UserSearch changes
ALTER TABLE UserSearch CHANGE COLUMN ResourceType ResourceType text;
ALTER TABLE UserSearch CHANGE COLUMN Language Language text;
ALTER TABLE UserSearch CHANGE COLUMN Audience Audience text;
ALTER TABLE UserSearch CHANGE COLUMN Format Format text;
ALTER TABLE UserSearch ADD COLUMN CumulativeRating text;

# Make DateIssued not required (optional)
UPDATE MetadataFields SET Optional = 1 WHERE FieldName = 'Date Issued';
