<?PHP

#
#   Axis--Database.php
#   A Simple SQL Database Abstraction Object
#
#   Copyright 1999-2002 Axis Data
#   This code is free software that can be used or redistributed under the
#   terms of Version 2 of the GNU General Public License, as published by the
#   Free Software Foundation (http://www.fsf.org).
#
#   Author:  Edward Almasy (almasy@axisdata.com)
#
#   Part of the AxisPHP library v1.2.5
#   For more information see http://www.axisdata.com/AxisPHP/
#

require_once("Axis--StandardLibrary.php");


class Database {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    function Database($UserName, $Password, $DatabaseName, $HostName = "localhost")
    {
        # open connection to DB server
        $this->Handle = mysql_connect($HostName, $UserName, $Password)
                or die("could not connect to database");

        # select DB
        mysql_select_db($DatabaseName, $this->Handle)
                or die(mysql_error($this->Handle));

        # save DB access values
        $this->DBHostName = $HostName;
        $this->DBName = $DatabaseName;
        $this->DBUserName = $UserName;
    }

    function DBHostName() {  return $this->DBHostName;  }
    function DBName() {  return $this->DBName;  }
    function DBUserName() {  return $this->DBUserName;  }

    function Query($QueryString, $FieldName = "")
    {
        global $APDBQueryDebugOutputFlag;
        global $APDBCachingFlag;
        global $APDBAdvancedCachingFlag;
        global $APDBQueryResultCache;
        global $APDBQueryCounter;
        global $APDBCachedQueryCounter;

        # if caching is enabled
        if ($APDBCachingFlag)
        {
            # if SQL statement is read-only
            if ($this->IsReadOnlyStatement($QueryString))
            {
                # if we have statement in cache
                if (isset($APDBQueryResultCache[$QueryString]["NumRows"]))
                {
                    if ($APDBQueryDebugOutputFlag) {  print("DB-C: $QueryString<br>\n");  }

                    # make sure query result looks okay
                    $this->QueryResult = TRUE;

                    # increment cache hit counter
                    $APDBCachedQueryCounter++;
                }
                else
                {
                    # execute SQL statement
                    if ($APDBQueryDebugOutputFlag) {  print("DB: $QueryString<br>\n");  }
                    $this->QueryResult = mysql_query($QueryString, $this->Handle)
                            or die(mysql_error($this->Handle));

                    # save number of rows in result
                    $NumRows = mysql_num_rows($this->QueryResult);
                    $APDBQueryResultCache[$QueryString]["NumRows"] = $NumRows;

                    # if too many rows returned to cache
                    if ($NumRows >= 50)
                    {
                        # dump query from cache
                        # (odd syntax because unset() doesn't work directly on globals)
                        unset($GLOBALS["APDBQueryResultCache"][$QueryString]);
                    }
                    else
                    {
                        # if advanced caching is enabled
                        if ($APDBAdvancedCachingFlag)
                        {
                            # save tables accessed by query
                            $APDBQueryResultCache[$QueryString]["TablesAccessed"] = $this->TablesAccessed($QueryString);
                        }

                        # if rows found
                        if ($NumRows > 0)
                        {
                            # cache query results
                            for ($Row = 0;  $Row < $NumRows;  $Row++)
                            {
                                $APDBQueryResultCache[$QueryString][$Row] = 
                                            mysql_fetch_assoc($this->QueryResult);
                            }
                        }
                    }
                }
            }
            else
            {
                # if advanced caching is enabled
                if ($APDBAdvancedCachingFlag)
                {
                    # if table modified by statement is known
                    $TableModified = $this->TableModified($QueryString);
                    if ($TableModified)
                    {
                        # for each cached query
                        foreach ($APDBQueryResultCache as $CachedQueryString => $CachedQueryResult)
                        {
                            # if we know what tables were accessed
                            if ($CachedQueryResult["TablesAccessed"])
                            {
                                # if tables accessed include the one we may modify
                                if (in_array($TableModified, $CachedQueryResult["TablesAccessed"]))
                                {
                                    # clear cached query results
                                    unset($GLOBALS["APDBQueryResultCache"][$CachedQueryString]);
                                }
                            }
                            else
                            {
                                # clear cached query results
                                unset($GLOBALS["APDBQueryResultCache"][$CachedQueryString]);
                            }
                        }
                    }
                    else
                    {
                        # clear entire query result cache
                        $APDBQueryResultCache = array();
                    }
                }
                else
                {
                    # clear entire query result cache
                    $APDBQueryResultCache = array();
                }

                # execute SQL statement
                if ($APDBQueryDebugOutputFlag) {  print("DB: $QueryString<br>\n");  }
                $this->QueryResult = mysql_query($QueryString, $this->Handle)
                        or die(mysql_error($this->Handle));
            }

            # reset row counter
            $this->RowCounter = 0;

            # set current SQL statement
            $this->LastRequestedQuery = $QueryString;

            # increment query counter
            $APDBQueryCounter++;
        }
        else
        {
            # execute SQL statement
            $this->QueryResult = mysql_query($QueryString, $this->Handle)
                    or die(mysql_error($this->Handle));
        }

        if (($this->QueryResult != FALSE) && ($FieldName != ""))
        {
            $Row = $this->FetchRow();
            return $Row[$FieldName];
        }
        else
        {
            return $this->QueryResult;
        }
    }

    function NumRowsSelected()
    {
        global $APDBCachingFlag;
        global $APDBQueryResultCache;

        # if caching is enabled and statement is in cache
        if (($APDBCachingFlag) && (isset($APDBQueryResultCache[$this->LastRequestedQuery]["NumRows"])))
        {
            # return cached number of rows to caller
            return $APDBQueryResultCache[$this->LastRequestedQuery]["NumRows"];
        }
        else
        {
            # retrieve number of rows and return to caller
            return mysql_num_rows($this->QueryResult);
        }
    }

    function FetchRow()
    {
        global $APDBCachingFlag;
        global $APDBQueryResultCache;

        # if caching is enabled and we have this query cached and less rows in result than row caching threshold
        $QueryString = $this->LastRequestedQuery;
        if ($APDBCachingFlag 
            && isset($APDBQueryResultCache[$QueryString]))
        {
            # retrieve row from cache
            $Result = $APDBQueryResultCache[$QueryString][$this->RowCounter];

            # increment row counter
            $this->RowCounter++;
        }
        else
        {
            # retrieve row from DB
            $Result = mysql_fetch_assoc($this->QueryResult);
        }
        
        # return row to caller
        return $Result;
    }
    function FetchNextRowArray() {  return $this->FetchRow();  }
    
    function FetchColumn($FieldName, $IndexFieldName = NULL)
    {
        $Array = array();
        while ($Record = $this->FetchRow())
        {
            if ($IndexFieldName != NULL)
            {
                $Array[$Record[$IndexFieldName]] = $Record[$FieldName];
            }
            else
            {
                $Array[] = $Record[$FieldName];
            }
        }
        return $Array;
    }
    
    function FetchField($FieldName)
    {
        $Record = $this->FetchRow();
        return $Record[$FieldName];
    }

    function LastInsertId($TableName)
    {
        return $this->Query(
                "SELECT LAST_INSERT_ID() AS InsertId FROM ".$TableName, 
                "InsertId");
    }
	
	function UpdateValue($TableName, $FieldName, $NewValue, $Condition, &$CachedRecord, $AddSlashes = FALSE)
	{
        # expand condition if supplied
        if ($Condition != NULL) {  $Condition = " WHERE ".$Condition;  }

		# if new value supplied
		if ($NewValue != DB_NOVALUE)
		{
			# if supplied value is integer
			if (is_int($NewValue))
			{
				# update value in database (without quoting value)
				$this->Query("UPDATE $TableName SET $FieldName = $NewValue $Condition");
			}
			else
			{
                # if string escaping requested
                if ($AddSlashes)
                {
                    # update value in database with escaping
                    $this->Query("UPDATE $TableName SET $FieldName = '".addslashes($NewValue)."' $Condition");
                }
                else
                {
                    # update value in database
                    $this->Query("UPDATE $TableName SET $FieldName = '".$NewValue."' $Condition");
                }
			}
			
			# if cached record supplied
            if ($CachedRecord != NULL)
			{
				# update value in cached record
                $CachedRecord[$FieldName] = $NewValue;
			}
			
			# return new value to caller
			return $NewValue;
		}
		else
		{
			# if cached record supplied
            if ($CachedRecord != NULL)
			{
				# return value from cached record to caller
                return $CachedRecord[$FieldName];
			}
			else
			{
				# read value from database and return it to caller
                return $this->Query("SELECT $FieldName FROM $TableName $Condition",
									$FieldName);
			}
		}
	}
    
    function LogComment($String)
    {
        $this->Query("-- ".$String);
    }
    
    function FieldExists($TableName, $FieldName)
    {
        $this->Query("DESC ".$TableName);
        while ($CurrentFieldName = $this->FetchField("Field"))
        {
            if ($CurrentFieldName == $FieldName) {  return TRUE;  }
        }
        return FALSE;
    }

    function QueryDebugOutput($NewSetting)
    {
        global $APDBQueryDebugOutputFlag;
        $APDBQueryDebugOutputFlag = $NewSetting;
    }

    # get/set whether caching is enabled
    function Caching($NewSetting)
    {
        global $APDBCachingFlag;
        $APDBCachingFlag = $NewSetting;
    }

    # get/set whether advanced caching is enabled
    function AdvancedCaching($NewSetting)
    {
        global $APDBAdvancedCachingFlag;
        $APDBAdvancedCachingFlag = $NewSetting;
    }

    function NumQueries()
    {
        global $APDBQueryCounter;
        return $APDBQueryCounter;
    }

    function NumCacheHits()
    {
        global $APDBCachedQueryCounter;
        return $APDBCachedQueryCounter;
    }

    function CacheHitRate()
    {
        global $APDBQueryCounter;
        global $APDBCachedQueryCounter;
        if ($APDBQueryCounter)
        {
            return ($APDBCachedQueryCounter / $APDBQueryCounter) * 100;
        }
        else
        {
            return 0;
        }
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $Handle;
    var $QueryResult;
    var $DBHostName;
    var $DBName;
    var $DBUserName;
    var $LastRequestedQuery;
    var $RowCounter;

    # determine whether SQL statement is one that modifies data
    function IsReadOnlyStatement($QueryString)
    {
        return preg_match("/^[ ]*SELECT /i", $QueryString) ? TRUE : FALSE;
    }

    # try to determine table modified by statement (returns FALSE if unknown)
    function TableModified($QueryString)
    {
        # assume we're not going to be able to determine table
        $TableName = FALSE;

        # split query into pieces
        $QueryString = trim($QueryString);
        $Words = preg_split("/\s+/", $QueryString);

        # if INSERT statement
        $WordIndex = 1;
        if (strtoupper($Words[0]) == "INSERT")
        {
            # skip over modifying keywords
            while ((strtoupper($Words[$WordIndex]) == "LOW_PRIORITY")
                    || (strtoupper($Words[$WordIndex]) == "DELAYED")
                    || (strtoupper($Words[$WordIndex]) == "IGNORE")
                    || (strtoupper($Words[$WordIndex]) == "INTO"))
            {
                $WordIndex++;
            }

            # next word is table name
            $TableName = $Words[$WordIndex];
        }
        # else if UPDATE statement
        elseif (strtoupper($Words[0]) == "UPDATE")
        {
            # skip over modifying keywords
            while ((strtoupper($Words[$WordIndex]) == "LOW_PRIORITY")
                    || (strtoupper($Words[$WordIndex]) == "IGNORE"))
            {
                $WordIndex++;
            }

            # if word following next word is SET
            if (strtoupper($Words[$WordIndex + 1]) == "SET")
            {
                # next word is table name
                $TableName = $Words[$WordIndex];
            }
        }
        # else if DELETE statement
        elseif (strtoupper($Words[0]) == "DELETE")
        {
            # skip over modifying keywords
            while ((strtoupper($Words[$WordIndex]) == "LOW_PRIORITY")
                    || (strtoupper($Words[$WordIndex]) == "IGNORE")
                    || (strtoupper($Words[$WordIndex]) == "QUICK"))
            {
                $WordIndex++;
            }

            # if next term is FROM
            if (strtoupper($Words[$WordIndex]) == "FROM")
            {
                # next word is table name
                $WordIndex++;
                $TableName = $Words[$WordIndex];
            }
        }

        # discard table name if it looks at all suspicious
        if ($TableName)
        {
            if (!preg_match("/[a-zA-Z0-9]+/", $TableName))
            {
                $TableName = FALSE;
            }
        }

        # return table name (or lack thereof) to caller
        return $TableName;
    }

    # try to determine tables accessed by statement (returns FALSE if unknown)
    function TablesAccessed($QueryString)
    {
        # assume we're not going to be able to determine tables
        $TableNames = FALSE;

        # split query into pieces
        $QueryString = trim($QueryString);
        $Words = preg_split("/\s+/", $QueryString);
        $UQueryString = strtoupper($QueryString);
        $UWords = preg_split("/\s+/", $UQueryString);

        # if SELECT statement
        if ($UWords[0] == "SELECT")
        {
            # keep going until we hit FROM or last word
            $WordIndex = 1;
            while (($UWords[$WordIndex] != "FROM") 
                    && strlen($UWords[$WordIndex]))
            {
                $WordIndex++;
            }

            # if we hit FROM
            if ($UWords[$WordIndex] == "FROM")
            {
                # for each word after FROM
                $WordIndex++;
                while (strlen($UWords[$WordIndex]))
                {
                    # if current word ends with comma
                    if (preg_match("/,$/", $Words[$WordIndex]))
                    {
                        # strip off comma and add word to table name list
                        $TableNames[] = substr($Words[$WordIndex], 0, -1);
                    }
                    else
                    {
                        # add word to table name list
                        $TableNames[] = $Words[$WordIndex];

                        # if next word is not comma
                        $WordIndex++;
                        if ($Words[$WordIndex] != ",")
                        {
                            # if word begins with comma
                            if (preg_match("/^,/", $Words[$WordIndex]))
                            {
                                # strip off comma (NOTE: modifies $Words array!)
                                $Words[$WordIndex] = substr($Words[$WordIndex], 1);

                                # decrement index so we start with this word next pass
                                $WordIndex--;
                            }
                            else
                            {
                                # stop scanning words (non-basic JOINs not yet handled)
                                break;
                            }
                        }
                    }

                    # move to next word
                    $WordIndex++;
                }
            }
        }

        # discard table names if they look at all suspicious
        if ($TableNames)
        {
            foreach ($TableNames as $Name)
            {
                if (!preg_match("/^[a-zA-Z0-9]+$/", $Name))
                {
                    $TableNames = FALSE;
                    break;
                }
            }
        }

        # return table name (or lack thereof) to caller
        return $TableNames;
    }
}

# define return values  (numerical values correspond to MySQL error codes)
define("DB_OKAY",               0);
define("DB_ERROR",              1);
define("DB_ACCESSDENIED",       2);
define("DB_UNKNOWNDB",          3);
define("DB_UNKNOWNTABLE",       4);
define("DB_SYNTAXERROR",        5);
define("DB_DBALREADYEXISTS",    6);
define("DB_DBDOESNOTEXIST",     7);
define("DB_DISKFULL",           8);

# define value to designate omitted arguments (so DB values can be set to NULL)
define("DB_NOVALUE", "!-_-_-DB_NOVALUE-_-_-!");

# MySQL error code mapping
$APDBErrorCodeMappings = array(
        1045    => DB_ACCESSDENIED,
        1049    => DB_UNKNOWNDB,
        1046    => DB_UNKNOWNTABLE,
        1064    => DB_SYNTAXERROR,
        1007    => DB_DBALREADYEXISTS,  # ?  (not sure)
        1008    => DB_DBDOESNOTEXIST,   # ?  (not sure)
        1021    => DB_DISKFULL,         # ?  (not sure)
        );

# debug output flag
$APDBQueryDebugOutputFlag = FALSE;
# query result caching flag
$APDBCachingFlag = FALSE;
# query result advanced caching flag
$APDBAdvancedCachingFlag = FALSE;
# global cache for query results
$APDBQueryResultCache = array();
# stats counters
$APDBQueryCounter = 0;
$APDBCachedQueryCounter = 0;


function PrintOptionListFromDB($DB, $Table, $Condition, $SortBy, $ResultVar, $ValueQuery, $LabelQuery, $SelectedValue, $Size = 1, $SubmitOnChange = "", $PrintEvenIfEmpty = 0)
{
    # set up condition and sorting parameters
    if ($Condition != "") {  $Condition = "WHERE ".$Condition;  }
    if ($SortBy != "") {  $SortBy = "ORDER BY ".$SortBy;  }

    # grab records to be listed from database
    $QueryString = sprintf("SELECT * FROM %s %s %s", 
            $Table, $Condition, $SortBy);
    $DB->Query($QueryString);

    # if records were found
    if ($DB->NumRowsSelected() > 0)
    {
        # build array of items
        while ($Row = $DB->FetchNextRowArray())
        {
            $Items[$Row[$ValueQuery]] = $Row[$LabelQuery];
        }

        # sort array if not already sorted
        if ($SortBy == "") {  asort($Items);  }
    }

    # print option list
    PrintOptionList($ResultVar, $Items, $SelectedValue, $SubmitOnChange, $Size, $PrintEvenIfEmpty);
}


?>
