<?php
#
#   FILE:  SPT--AddControlledName.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");

CheckAuthorization(PRIV_NAMEADMIN);

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# returns true if field uses qualifiers
function FieldUsesQualifiers()
{
    global $HTTP_POST_VARS;
    global $F_ControlledNameTypeId;

    $Name = GetControlledNameType($F_ControlledNameTypeId);
      
    $Schema = & new MetadataSchema();
    $Field = $Schema->GetFieldByName($Name);
    return $Field->UsesQualifiers();
}

# function to return if any Controlled Name types exist
function ControlledNamesExist()
{
    $DB =& new SPTDatabase();

    $Query = "Select * from ControlledNameTypes where ControlledNameIsList=0".
        " ORDER BY ControlledNameTypeName";
    $DB->Query($Query);
    return $DB->NumRowsSelected();
}

#  display a ControlledName list of values as an option menu
function DisplayControlledNameList()
{
    global $F_ControlledNameTypeId;

    $DB =& new SPTDatabase();

    $Query = "Select * from ControlledNameTypes where ControlledNameIsList=0".
        " ORDER BY ControlledNameTypeName";
    $DB->Query($Query);

    while($Entry = $DB->FetchNextRowArray())
    {
        $Items[$Entry["ControlledNameTypeId"]] = 
            $Entry["ControlledNameTypeName"];
    }
    PrintOptionList("F_ControlledNameTypeId", $Items, $F_ControlledNameTypeId,
        1, 1, NULL, false);
}

# function to print selected ControlledName
function PrintDisplayString()
{
    global $F_ControlledNameTypeId;

    $Name = GetControlledNameType($F_ControlledNameTypeId);
    print $Name;
}

# print ControlledName
function PrintControlledName()
{
    global $F_ControlledName;

    print $F_ControlledName;
}

# print Variant 
function PrintVariant()
{
    global $F_Variant;

    print $F_Variant;
}

# returns true if field uses item level qualifiers
function FieldHasItemLevelQualifiers()
{
    global $HTTP_POST_VARS;
    global $F_ControlledNameTypeId;

    $Name = GetControlledNameType($F_ControlledNameTypeId);

    $Schema = & new MetadataSchema();
    $Field = $Schema->GetFieldByName($Name);
    return $Field->HasItemLevelQualifiers();
}

#  display a Qualifier list of values as an option menu
function PrintQualifierOrList()
{
    global $HTTP_POST_VARS;
    global $F_ControlledNameTypeId;

    $Schema = & new MetadataSchema();

    $Name = GetControlledNameType($F_ControlledNameTypeId);
    $Field = $Schema->GetFieldByName($Name);

    if($Field->HasItemLevelQualifiers())
    {
        # first value is "--"
        $Items = $Field->AssociatedQualifierList();
        $Items["--"] = "--";
        ksort($Items);

        PrintOptionList("F_Qualifier", $Items, 0, 0, 1, NULL, false);
    }
    else
    {
        $Qualifier = & new Qualifier($Field->DefaultQualifier());
        if(is_object($Qualifier))
            print $Qualifier->Name();
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

$DB =& new SPTDatabase();

$F_Variant = $Session->Get("F_Variant");
$F_ControlledName = $Session->Get("F_ControlledName");
$F_ControlledNameTypeId = $Session->Get("F_ControlledNameTypeId");

if(is_null($F_ControlledNameTypeId))
{
    $Query = "Select ControlledNameTypeId from ControlledNameTypes ".
        "where ControlledNameIsList=0 ".
        "ORDER BY ControlledNameTypeName LIMIT 1";
    $F_ControlledNameTypeId = $DB->Query($Query, "ControlledNameTypeId");
}

PageTitle("Add Controlled Names");
$NavDirCorrection = "../";

include("include/SPT--StandardHtmlPageLoad.php");


?>
