<?php
#
#   FILE:  SPT--AddRecord.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--Classification.php");
require_once("include/SPT--SearchEngine.php");
require_once("include/SPT--Recommender.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--SPTDate.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--ResourceFactory.php");

# provide relative path to base SPT directory
$NavDirCorrection = "../";

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print DBFieldName
function PrintDBFieldName()
{
    global $Field;

    print $Field->DBFieldName();
}

# print FieldName
function PrintFieldName()
{
    global $Field;

    print $Field->Name();
}

# print Field value
function PrintValue()
{
    global $Value;

    print $Value;
}

function PrintQualifier()
{
    global $Field;
    global $Result;
    global $Value;
    global $GenericId;
    global $QualifierId;

    if($Field->UsesQualifiers())
    {
        $Qualifier = $Result[$Field->Name()." Qualifier"];
        # normal field
        if(is_object($Qualifier))
        {
            $Name = $Qualifier->Name();
            if(!empty($Name))
                print " <small>(<a href=\"".$Qualifier->Url()."\">".
                    $Qualifier->Name()."</a>)</small>";
        }            
        # controlled name, options, or classifications, use global Qualifier
        else if(is_array($Qualifier))
        {
            # look up this qualifier
            foreach($Qualifier as $ArrayId => $QualifierObj)
            {
                if($ArrayId == $GenericId)
                    break;
            }
            if(is_object($QualifierObj))
            {
                $Name = $QualifierObj->Name();
                if(!empty($Name))
                    print "<small> (<a href=\"".$QualifierObj->Url()."\">".
                        $QualifierObj->Name()."</a>)</small>";
            }
        }
    }
}

# display text fields
function DisplayAllFields()
{
    global $Result;
    global $Field;
    global $Value;
    global $QualifierId;
    global $User;
    global $ResourceId;
    global $SPTImage;

    $Resource = & new Resource($ResourceId);

    # Get the schema
    $Schema = & new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(NULL, MDFORDER_EDITING);

    foreach($Fields as $Field)
    {
        if($Field->Enabled())
        {
            # get value if updating record
            if(!empty($Result[$Field->Name()]))
            {
                $Value = $Result[$Field->Name()];

                switch($Field->Type())
                {
                    case MDFTYPE_NUMBER:
                    case MDFTYPE_TIMESTAMP:
                    case MDFTYPE_TEXT:
                        DisplayTextField();
                        break;

                    case MDFTYPE_PARAGRAPH:
                        DisplayParagraph();
                        break;

                    case MDFTYPE_DATE:
                        $Date = $Value;
                        if(is_object($Date))
                        {
                            $Value = $Date->Formatted();
                            if(!empty($Value))
                                DisplayTextField();
                        }
                        break;

                    case MDFTYPE_FLAG:
                        $Value = $Result[$Field->Name()] ? 
                            $Field->FlagOnLabel() : $Field->FlagOffLabel();
                        DisplayFlagField();
				        break;

                    case MDFTYPE_TREE:
                        DisplayClassifications();
                        break;

                    case MDFTYPE_OPTION:
                        DisplayOptions();
                        break;

                    case MDFTYPE_CONTROLLEDNAME:
                        DisplayControlledNames();
                        break;

                    case MDFTYPE_USER:
                        $NewUser = $Value;
                        if(is_object($NewUser))
                        {
                            $Value = $NewUser->Get("UserName");
                            DisplayTextField();
                        }
                        break;

                    case MDFTYPE_IMAGE:
                        if(is_object($Resource))
                        {
                            $SPTImage = $Resource->GetByField($Field, TRUE);
                            if(is_object($SPTImage))
                            {
                                if(is_readable($SPTImage->ThumbnailUrl()))
                                    DisplayImageField($Field->Name(),
                                        $SPTImage->Url(),
                                        $SPTImage->ThumbnailUrl(),
                                        $SPTImage->AltText());
                            }
                        }
                        break;
                }
            }
        }
    }
}

# print Url
function PrintUrl()
{
    global $SPTImage;

    print $SPTImage->Url();
}

# print ThumbnailUrl
function PrintThumbnailUrl()
{
    global $SPTImage;

    print $SPTImage->ThumbnailUrl();
}

# print ThumbnailUrl
function PrintAltText()
{
    global $SPTImage;

    print $SPTImage->AltText();
}

# display controlled names and buttons
function DisplayImageFields()
{
    global $ResourceId;
    global $Field;
    global $SPTImage;

    # Get the schema
    $Schema = & new MetadataSchema();
    $DB =& new SPTDatabase();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_IMAGE);

    foreach($Fields as $Field)
    {
        if($Field->Enabled())
        {
            if($ResourceId)
            {
                $Resource = & new Resource($ResourceId);
                $SPTImage = $Resource->GetByField($Field, TRUE);

                if(is_object($SPTImage))
                {
                    if(is_readable($SPTImage->ThumbnailUrl()))
                        DisplayImageField($Field->Name(),
                            $SPTImage->Url(),
                            $SPTImage->ThumbnailUrl(),
                            $SPTImage->AltText());
                }
            }
        }
    }
}

#  list out all Options associated with a Resource
function DisplayOptions()
{
    global $Resource, $Field, $Value, $GenericId;

    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_OPTION); 

    foreach($Fields as $Field)
    {
        $Options = $Resource->Get($Field->Name());
        if(is_array($Options))
        {
            foreach($Options as $GenericId => $Value)
            {
                # ignore empty authors and NULL values
                if (isset($Value))
                {
                    DisplayTextField();
                }
            }
        }
    }
}

#  list out all ControlledNames associated with a Resource
function DisplayControlledNames()
{
    global $Resource, $Field, $Value, $GenericId;

    $Schema = & new MetadataSchema();
    $ControlledNames = $Resource->Get($Field->Name());
    if(is_array($ControlledNames))
    {
        foreach($ControlledNames as $GenericId => $Value)
        {
            # ignore empty authors and NULL values
            if (isset($Value))
            {
                DisplayTextField();
            }
        }
    }
}

#  list out all Classifications associated with a Resource
function DisplayClassifications()
{
    global $Resource, $Field, $Value, $GenericId;

    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_TREE); 

    foreach($Fields as $Field)
    {
        $Classifications = $Resource->Get($Field->Name());
        if(is_array($Classifications))
        {
            foreach($Classifications as $GenericId => $Value)
            {
                # ignore empty values and NULL values
                if (isset($Value))
                {
                    DisplayTextField();
                }
            }
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# display add status, this is also exported
function GetAddStatus()
{
    global $Action;

    if($Action == "Add Record") 
        return "Added";
    else if ($Action == "Duplicate Resource") 
        return "Duplicated";
    else if ($Action == "Delete Resource")
        return "Deleted";
    else
        return "Updated";
}

# process Add/Update Resource Record
function AddUpdateResourceRecord()
{
    global $Result, $ResourceId, $Resource, $Action;
    global $HTTP_POST_VARS, $User, $Session, $SysConfig;

    $DB = & new SPTDatabase();

    $QualifierArray = array();
    $Schema = & new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_TEXT | MDFTYPE_PARAGRAPH | 
            MDFTYPE_NUMBER | MDFTYPE_DATE | MDFTYPE_TIMESTAMP | 
            MDFTYPE_FLAG | MDFTYPE_USER | MDFTYPE_IMAGE | MDFTYPE_OPTION |
            MDFTYPE_CONTROLLEDNAME);

    # loop through each field
    foreach($Fields as $Field)
    {
        if($Field->Enabled())
        {
            # extract the field names posted value
            $DBName = $Field->DBFieldName();
            $Value = $HTTP_POST_VARS["$DBName"];
#            echo "$DBName = $Value<br>";

            # extract qualifier for this field
            if($Field->UsesQualifiers() && $Field->HasItemLevelQualifiers()
                && !($Field->Type() & 
                (MDFTYPE_CONTROLLEDNAME | MDFTYPE_OPTION | MDFTYPE_TREE)))
            {
                $QualifierField = $DBName."Qualifier";
                $QualifierId = $HTTP_POST_VARS["$QualifierField"];
                $QualifierArray[$Field->Id()] = $QualifierId;
            }

            switch($Field->Type())
            {
                case MDFTYPE_NUMBER:
                    # check min and max for number fields
                    if(is_numeric($Value))
                    {
                        $Min = $Field->MinValue();
                        $Max = $Field->MaxValue();
                        if(isset($Min))
                        {
                            if($Value < $Field->MinValue())
                            {
                                $NumberError .= $Field->Name().
                                    " < min value ($Min), "; 
                            }
                        }
                        if(isset($Max))
                        {
                            if($Value > $Field->MaxValue())
                            {
                                $NumberError .= $Field->Name().
                                    " > max value ($Max), "; 
                            }
                        }
                    }
                    else if(!empty($Value) && is_string($Value))
                    {
                        $NumberError .= $Field->Name().
                            " is not a valid number, ";
                    }
                    # translate empty strings to NULL for numbers
                    if(empty($Value))
                        $Value = NULL;

                    break;
                    
                case MDFTYPE_DATE:
                    # check Dates for valid format
                    $Date = & new SPTDate($Value);

                    # check for invalid Date format
                    if($Date->BeginDate() == "0000-00-00" && !empty($Value))
                    {
                        $DateError .= 
                            $Field->Name()." is not a valid date format, ";
                    }
                    else
                    {
                        $Value = $Date;
                    }
                    break;

                case MDFTYPE_IMAGE:
                    # update Alt Text
                    $SPTImage = $Resource->GetByField($Field, TRUE);
                    if(is_object($SPTImage))
                    {
                        $DBName = $DBName."AltText";
                        $Value = $HTTP_POST_VARS["$DBName"];
                        $SPTImage->AltText($Value);
                        $Value = $SPTImage->Id();
                    }
                    else
                        $Value = 0;
                    break;

                case MDFTYPE_USER:
                    # Don't change AddedById except for initial Add 
                    if($Action != "Add Record" && $DBName == "AddedById")
                        $Value = $Resource->Get("Added By Id", $Value);
                    else                        
                        $Value = $User;
                    break;
                
                case MDFTYPE_CONTROLLEDNAME:
                case MDFTYPE_TREE:
                    $Value = $Resource->GetByField($Field);
                    break;

                case MDFTYPE_OPTION:
                    if(is_array($Value))
                     {
                         # erase existing values
                         $Resource->ClearByField($Field);
                         $NewValue = array();
                         foreach($Value as $Id)
                         {
                            $NewValue[$Id] = GetControlledName($Id);
                         }
                         $Value = $NewValue;
                     }
                     break;

                case MDFTYPE_TEXT:
                        # strip out unwanted tags, include <br>
                        $Value = strip_tags($Value, 
                            '<a><b><i><u><p><q><s><pre><sub><sup>');
                    break;

                case MDFTYPE_PARAGRAPH:
                        # strip out unwanted tags, allow <br> for paragraphs
                        $Value = strip_tags($Value, 
                            '<a><b><i><u><p><q><s><br><pre><sub><sup>');
                    break;

                case MDFTYPE_FLAG:
                case MDFTYPE_TIMESTAMP:
                default:
                    break;
            }

            # ERROR Checks follow
            # check for required fields (not optional, ignore timestamps)
            if(!$Field->Optional() && !($Field->Type() & 
                (MDFTYPE_TIMESTAMP | MDFTYPE_FLAG | MDFTYPE_USER)))
            {
                # ignore empty flags or users   
                if(empty($Value))
                {
                    $MissingError .= $Field->Name().", "; 
                }
            }

            # cache FieldId and Value for setting below 
            $ResourceArray[$Field->Id()] = $Value;
        }
    }

    # only report errors if adding or updating
    if($Action == "Add Record" || $Action == "Update Resource")
    {
        # report missing required fields
        if(!empty($MissingError))
        {
            $ErrorMessage = "Error: Missing required field(s): ".$MissingError;
            $ErrorMessage = substr($ErrorMessage, 0, strlen($ErrorMessage) - 2);
            $ErrorMessage .= "<br>";
        }

        # report min/max violations
        if(!empty($NumberError))
        {
            $ErrorMessage .= "Error: Number is invalid or fails limits:<br>".
            $NumberError;
            $ErrorMessage = substr($ErrorMessage, 0, strlen($ErrorMessage) - 2);
            $ErrorMessage .= "<br>";
        }

        # report date errors
        if(!empty($DateError))
        {
            $ErrorMessage .= "Error: Date field is invalid:<br>".$DateError;
            $ErrorMessage = substr($ErrorMessage, 0, strlen($ErrorMessage) - 2);
            $ErrorMessage .= "<br>";
        }

        # display error messages
        if(!empty($ErrorMessage)) 
        {
            $ErrorMessage .= "Please select Back and correct.";
            ErrorOut($ErrorMessage);    
        }
    }

    # now set each Resource field    
    foreach($ResourceArray as $FieldId => $Value)
    {
#        echo "FieldId=$FieldId, Value=$Value<br>";
        $Resource->SetByFieldId($FieldId, $Value);
    }

    # set item level qualifiers
    foreach($QualifierArray as $FieldId => $Value)
    {
#        echo "FieldId=$FieldId, Value=$Value<br>";
        $Resource->SetQualifierByFieldId($FieldId, $Value);
    }

    if($Action == "Add Record")
    {
        # force date of Record Creation to current time
        $Resource->Set("Date Of Record Creation", date("Y-m-d H:i:s"));
        
        # work to do if a temp resource
        if($Resource->IsTempResource() && $Action == "Add Record")
        {
            # now convert from a temp resource to a real resource
            $Resource->IsTempResource(FALSE);
            $ResourceId = $Resource->Id();
        }
    }
    # force date last modified to current time
    $Resource->Set("Date Last Modified", date("Y-m-d H:i:s"));
    
    # query out added record for displaying results
    $Result = $Resource->GetAsArray();

    # only update search and recommender dbs if doing a true add or update 
    if($Action == "Add Record" || $Action == "Update Resource")
    {
        if($SysConfig->SearchDBEnabled())
        {
            # update search DB for this record
            $SearchEngine =& new SPTSearchEngine();
            $SearchEngine->UpdateForResource($ResourceId);
        }

        if($SysConfig->RecommenderDBEnabled())
        {
            # update recommender DB for this record
            $Recommender =& new SPTRecommender();
            $Recommender->UpdateForItem($ResourceId);
        }
    }
}

# add more classifications
function AddMoreClassifications()
{
    global $Session;

    PrintAutoRefreshPage("Search Classifications", 
        "SPT--SearchClassification.php"); 
    exit;
}

function RemoveClassifications($Name)
{
    global $Session, $Resource, $ResourceId, $HTTP_POST_VARS;

    reset($HTTP_POST_VARS);
    while (list($var, $value) = each ($HTTP_POST_VARS))
    {
        if(ereg("del_classid_([0-9]+)",$var,$regs))
        {
            if(!empty($value))
            { 
                $Resource->Clear($Name, $value);

                # update Classification resource count
                $Class =& new Classification($value);
                $Class->RecalcResourceCount();
            }
        }
    }

    # return to Entry screen
    PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
    exit;
}


# assign or remove controlled names to the resource
function AddMoreControlledNames($Name)
{
    global $ResourceId, $Session;

    # get the controlledname type by stripping off trailing "s"
    $DefaultTypeId = GetControlledNameTypeId($Name);

    $Session->PassVariable("DefaultTypeId", $DefaultTypeId);
    PrintAutoRefreshPage("Search Controlled Names", 
        "SPT--SearchControlledName.php"); 
    exit;
}

function RemoveControlledNames($Name)
{
    global $Resource, $ResourceId, $HTTP_POST_VARS, $Session;

    reset($HTTP_POST_VARS);
    while (list($var, $value) = each ($HTTP_POST_VARS))
    {
        if(ereg("del_id_([0-9]+)",$var,$regs))
        {
            if(!empty($value))
            { 
                $Id[$value] = $value;
            }
        }
    }
    $Resource->Clear($Name, $Id);

    # return to the entry screen
    PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
    exit;
}

# process images
function UploadImage()  
{
    global $HTTP_SERVER_VARS, $HTTP_POST_FILES, $HTTP_POST_VARS;
    global $NavDirCorrection, $Session, $Resource, $ResourceId;

    # Get the schema
    $Schema = & new MetadataSchema();
    $DB =& new SPTDatabase();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_IMAGE);

    foreach($Fields as $Field)
    {
        if($Field->Enabled())
        {
            $Name = $Field->DBFieldName();
            $AltText = $Field->DBFieldName()."AltText";

            $ScriptFileName = $HTTP_SERVER_VARS['SCRIPT_FILENAME'];

            $TempFile = dirname($ScriptFileName).
                "/".$NavDirCorrection."ImageStorage/".
                $HTTP_POST_FILES[$Name]['name'];

            # open import file for reading
            if (is_uploaded_file($HTTP_POST_FILES[$Name]['tmp_name']))
            {
                copy($HTTP_POST_FILES[$Name]['tmp_name'], $TempFile);
                $Image =& new SPTImage($TempFile, 
                    $Field->MaxPreviewWidth(), $Field->MaxPreviewHeight(),
                    $Field->MaxThumbnailWidth(), $Field->MaxThumbnailWidth());

                # set AltText
                $Image->AltText($HTTP_POST_VARS["$AltText"]);

                # remove temp files
                unlink($HTTP_POST_FILES[$Name]['tmp_name']);
                unlink($TempFile);

                # check for valid image object creation
                if($Image->Format() == IMGTYPE_UNKNOWN)
                {
                    $ErrorMessage = 
                        "Uploaded file is not in a supported format.";
                    ErrorOut($ErrorMessage);
                }
                $Resource->Set($Field->Name(), $Image->Id());
            }
            # no file name entered, just return
            else if(empty($HTTP_POST_FILES[$Name]['name']))
            {
            }
            else
            {
                $ErrorMessage = "Possible file upload attack.".
                        "<BR>Filename: " .$HTTP_POST_FILES[$Name]['name'];
                ErrorOut($ErrorMessage);
            }
        }
    }
    # return to Entry screen
    PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
    exit;
}

# delete image
function DeleteImage($Name)
{
    global $ResourceId, $Session;

    # Get the schema
    $Schema = & new MetadataSchema();
    $DB =& new SPTDatabase();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_IMAGE);

    foreach($Fields as $Field)
    {
        if($Field->Enabled() && $Name == $Field->Name())
        {
            $Resource = & new Resource($ResourceId);
            $SPTImage = $Resource->GetByField($Field, TRUE);
            $SPTImage->Delete();
        }
    }
                 
    # return to Entry screen
    PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
    exit;
}    

# duplicate Resource Record
function DuplicateResourceRecord()
{
    global $ResourceId, $Resource, $Result, $User;

    $ResourceFactory = & new ResourceFactory();
    $NewResource = $ResourceFactory->DuplicateResource($ResourceId);
    $Title = $NewResource->Get("Title");

    # convert new temp resource to a real resource
    $NewResource->IsTempResource(FALSE);
    $NewResource->Set("Title", $Title."  (DUPLICATE)");
    $NewResource->Set("Date Of Record Creation", date("Y-m-d H:i:s"));
    $NewResource->Set("Date Last Modified", date("Y-m-d H:i:s"));
    $NewResource->Set("Added By Id", $User);
    $NewResource->Set("Last Modified By Id", $User);
    $Resource = $NewResource;
    $Result = $Resource->GetAsArray();
    $ResourceId = $Resource->Id();
}

# delete a record
function ConfirmDeleteResource()
{
    global $Session, $ResourceId;

    # go to confirm delete screen
    PrintAutoRefreshPage("Delete Resource", "SPT--ConfirmDeleteRecord.php");
    exit;
}

function DeleteResource()
{
    global $Resource;

    $Resource->Delete();
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN);

if(isset($HTTP_POST_VARS["ResourceId"]))
    $ResourceId = $HTTP_POST_VARS["ResourceId"];
else
    $ResourceId = $Session->Get("ResourceId");

# grab existing resource
$RFactory = & new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();
$Resource = & new Resource($ResourceId);

# find out which button was selected
$Submit = $HTTP_POST_VARS["Submit"];
$Definition = $HTTP_POST_VARS["Definition"];

# get first two words of submit button to determine action
$Words = explode(" ", $Submit); 
$Action = $Words[0]." ".$Words[1];

# get third word for classifications
if($Words[2] == "Classifications")
    $Action .= " ".$Words[2];

# get controlled name or image name
$Begin = strpos($Submit, $Words[2]); 

# strip off trailing "s" for ControlledNames only
if($Words[1] == "Image")
    $Name = substr($Submit, $Begin, strlen($Submit)-$Begin);
else
    $Name = substr($Submit, $Begin, strlen($Submit)-$Begin-1);

# field definition link selected
if(isset($HTTP_GET_VARS["FieldId"]))
{
    AddUpdateResourceRecord();
    $Session->PassVariable("FieldId", $HTTP_GET_VARS["FieldId"]);
    PrintAutoRefreshPage("Field Definition", "SPT--FieldDefinition.php");
    exit;
}

switch($Action)
{
    case "Add Record": 
        AddUpdateResourceRecord();
        $RFactory->ClearCurrentEditedItemId();
        break;

    case "Update Resource":
        AddUpdateResourceRecord();
        $RFactory->ClearCurrentEditedItemId();
        break;

    case "Duplicate Resource":
        DuplicateResourceRecord();
        $RFactory->ClearCurrentEditedItemId();
        break;

    case "Delete Resource":
        # only Delete when fourth word exists = Title of Resource 
        if(empty($Words[3]))
            ConfirmDeleteResource();
        else
        {
            DeleteResource();
            $RFactory->ClearCurrentEditedItemId();
        }
        break;

    case "Delete Resource":
        DeleteResource();
        break;

    case "Add More Classifications":
        AddUpdateResourceRecord();
        AddMoreClassifications();
        break;

    case "Remove Checked Classifications":
        AddUpdateResourceRecord();
        RemoveClassifications($Name);
        break;

    # controlled names
    case "Add More":
        AddUpdateResourceRecord();
        AddMoreControlledNames($Name);
        break;

    # controlled names
    case "Remove Checked":
        AddUpdateResourceRecord();
        RemoveControlledNames($Name);
        break;

    case "Upload Image":
        AddUpdateResourceRecord();
        UploadImage();
        break;

    case "Delete Image":
        AddUpdateResourceRecord();
        DeleteImage($Name);
        break;

    case "Cancel ":
        if ($Resource->IsTempResource())
        {
            $Resource->Delete();
        }
        $RFactory->ClearCurrentEditedItemId();
        PrintAutoRefreshPage("Cancelling Resource Editing", "SPT--MDHome.php");
        exit;
        break;

    # return to Entry screen
    default:
        PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
        exit;
        break;
}        

PageTitle("Record " .GetAddStatus());
include("include/SPT--StandardHtmlPageLoad.php");

?>
