<?php
#
#   FILE:  SPT--AssignControlledName.php
#
#   FUNCTIONS PROVIDED:
#       DisplayAddedControlledNames()
#           - displays newly added ControlledNames, updates intersection
#             tables, and updates DateLastModified for affectd Resources 
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--ResourceFactory.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# process selected controlled names
function ProcessSelectedControlledNames()
{
    global $HTTP_POST_VARS;
    global $ResourceId;

    $DB =& new SPTDatabase();

    reset($HTTP_POST_VARS);
    while(list($Var, $Value) = each ($HTTP_POST_VARS))
    {
        if(ereg("cn_([0-9]+)", $Var, $Regs) )
        {
            $Value = trim($Value);
            if($Value != "")
            {
                $ControlledName = $Value;
                continue;
            }
        }
        if(ereg("cnid_([0-9]+)", $Var, $Regs) )
        {
            $Value = trim($Value);
            if($Value != "")
            {
                $ControlledNameId = $Value;

                $query = "INSERT into ResourceNameInts set ".
                "ResourceId = $ResourceId, ".
                "ControlledNameId = $ControlledNameId";

                $DB->Query($query);
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN);

# get currently edited resource
$RFactory = & new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

ProcessSelectedControlledNames();

# return to the DB Entry page
$Link = "SPT--DBEntry.php?ResourceId=".$ResourceId;
PrintAutoRefreshPage("Add New Record", $Link);
?>
