<?PHP

#
#   FILE:  SPT--EditPasswordMailComplete.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN);

if(isset($HTTP_POST_VARS["F_PasswordMailSubject"]))
    $F_PasswordMailSubject = $HTTP_POST_VARS["F_PasswordMailSubject"];
else
    $F_PasswordMailSubject = $Session->Get("F_PasswordMailSubject");  

if(isset($HTTP_POST_VARS["F_PasswordMailBody"]))
    $F_PasswordMailBody = $HTTP_POST_VARS["F_PasswordMailBody"];
else
    $F_PasswordMailBody = $Session->Get("F_PasswordMailBody");  

# if save changes was requested
if ($HTTP_POST_VARS["Submit"] != "Cancel")
{
    # if new e-mail subject is valid
    $F_PasswordMailSubject = trim($F_PasswordMailSubject);
    if (strlen($F_PasswordMailSubject) > 0)
    {
        # save new e-mail subject
        $SysConfig->PasswordMailSubject($F_PasswordMailSubject);
    }
    else
    {
        # add error message to error list
        $ErrorMessages =& new ErrorList();
        $ErrorMessages->AddMessage(
                "The subject line must contain some text.");
        $Session->PassVariable("F_PasswordMailSubject");
    }

    # if new e-mail body is valid
    $F_PasswordMailBody = trim($F_PasswordMailBody);
    if (substr_count($F_PasswordMailBody, "X-PASSWORD-X") > 0)
    {
        # save new e-mail body
        $SysConfig->PasswordMailBody($F_PasswordMailBody);
    }
    else
    {
        # add error message to error list
        $ErrorMessages =& new ErrorList();
        $ErrorMessages->AddMessage(
                "The message body must, at minimum, contain the special string for the user's password (X-PASSWORD-X).");
        $Session->PassVariable("F_PasswordMailBody");
    }
}

# if errors were found
if (isset($ErrorMessages))
{
    # return to editing page with error messages
    $Session->PassVariable("ErrorMessages");
    PrintAutoRefreshPage("Errors Found", "SPT--EditPasswordMail.php");
}
else
{
    # go to classification selection page for parent of edited classification
    PrintAutoRefreshPage("New Account Password E-Mail Editing Complete", 
            "SPT--SysAdmin.php");
}

?>
