<?PHP
#
#   FILE:  SPT--RegisterPortal.php
#
#   FUNCTIONS PROVIDED:
#       PrintRegistrationInfo()
#           - print list of info that will be sent when registering
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   OPTIONAL FUNCTIONS:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
PageTitle("");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print list if info that will be sent when registering
function PrintRegistrationInfo()
{
    global $SysConfig;
    global $DB;
    global $HTTP_SERVER_VARS;
    global $SPT_SoftwareVersionToDisplay;

    # general site info
    print("Software: ".(SoftwareIsCWIS() ? "CWIS" : "SPT")." ".$SPT_SoftwareVersionToDisplay."<br>\n");
    print("Site Name: <i>".$SysConfig->PortalName()."</i><br>\n");
    print("Site URI: <i>".$HTTP_SERVER_VARS["SERVER_NAME"].dirname($HTTP_SERVER_VARS["REQUEST_URI"])."</i><br>\n");
    print("Admin E-Mail: <i>".$SysConfig->AdminEmail()."</i><br>\n");

    # configuration settings
    print("Default UI: ".$SysConfig->DefaultActiveUI()."<br>\n");
    print("Current Theme: ".$SysConfig->CurrentTheme()."<br>\n");
    print("Forums: ".($SysConfig->ForumsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("User Agents: ".($SysConfig->UserAgentsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Announcements: ".($SysConfig->AnnouncementsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Multiple UIs: ".($SysConfig->AllowMultipleUIsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Ratings: ".($SysConfig->ResourceRatingsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Comments: ".($SysConfig->ResourceCommentsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Search Update: ".($SysConfig->SearchDBEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Recommender Update: ".($SysConfig->RecommenderDBEnabled() ? "ENABLED" : "DISABLED")."<br>\n");

    # resources info
    $ResourceCount = $DB->Query("SELECT COUNT(*) AS ResourceCount "
            ."FROM Resources", "ResourceCount");
    print("Resource Count: ".$ResourceCount."<br>\n");
    $ReleasedResourceCount = $DB->Query("SELECT COUNT(*) AS ResourceCount "
            ."FROM Resources WHERE ReleaseFlag = 1", "ResourceCount");
    print("Released Count: ".$ReleasedResourceCount."<br>\n");
    $RatedResourceCount = $DB->Query("SELECT COUNT(DISTINCT ResourceId) AS ResourceCount "
            ."FROM ResourceRatings", "ResourceCount");
    print("Rating Count: ".$RatedResourceCount."<br>\n");
    $ClassCount = $DB->Query("SELECT COUNT(*) AS ClassCount "
            ."FROM Classifications", "ClassCount");
    print("Classification Count: ".$ClassCount."<br>\n");
    $SampleCount = $DB->Query("SELECT COUNT(*) AS ResourceCount FROM Resources"
                              ." WHERE INSTR(Description, '[--SAMPLE RECORD--]') > 0",
                              "ResourceCount"); 
    print("Sample Count: ".$SampleCount."<br>\n");
    $TermCount = $DB->Query("SELECT COUNT(*) AS TotalCount "
            ."FROM SearchWords", "TotalCount");
    print("Search Term Count: ".$TermCount."<br>\n");

    # operating environment
    print("PHP Version: ".phpversion()."<br>\n");
    print("MySQL Client Version: ".mysql_get_client_info()."<br>\n");
    print("MySQL Server Version: ".mysql_get_server_info()."<br>\n");
    print("MySQL Connection Type: ".mysql_get_host_info()."<br>\n");
    print("HTTP Server: <i>".$HTTP_SERVER_VARS["SERVER_SOFTWARE"]."</i><br>\n");
    $OSInfo = exec("uname -a");
    print("OS Stamp: <i>".$OSInfo."</i><br>\n");
}

# print current content of user-entered registration settings
function PrintContactName() {  global $SysConfig;  print($SysConfig->ContactName());  }
function PrintContactEmail() {  global $SysConfig;  print($SysConfig->ContactEmail());  }
function PrintOrganization() {  global $SysConfig;  print($SysConfig->Organization());  }
function PrintOrganizationType() {  global $SysConfig;  print($SysConfig->OrganizationType());  }
function PrintSiteType() {  global $SysConfig;  print($SysConfig->SiteType());  }
function PrintOkayToListSite() {  global $SysConfig;  print($SysConfig->OkayToListSite());  }
function PrintCheckedIfOrganizationTypeIs($OrganizationType) {  global $SysConfig;  print(($SysConfig->OrganizationType() == $OrganizationType) ? " checked" : "");  }
function PrintCheckedIfSiteTypeIs($SiteType) {  global $SysConfig;  print(($SysConfig->SiteType() == $SiteType) ? " checked" : "");  }
function PrintCheckedIfOkayToListSite() {  global $SysConfig;  print(($SysConfig->OkayToListSite()) ? " checked" : "");  }


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

include("include/SPT--StandardHtmlPageLoad.php");

?>
