<?PHP
#
#   FILE:  SPT--RegisterPortalComplete.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   OPTIONAL FUNCTIONS:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       F_Comments
#           - any registration comments submitted by the user
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("Scout--XMLStream.php");
PageTitle("Registration Complete");

# destination for registration info e-mail
$RegInfoRecipient = "register@scout.wisc.edu";


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function GetRegistrationMessageContent($UserEnteredVals)
{
    global $SysConfig;
    global $User;
    global $DB;
    global $HTTP_SERVER_VARS;
    global $SPT_SoftwareVersionToDisplay;

    # create XML stream to use in generating content
    $XS =& new XMLStream();
    $SchemaInfo = array(
        "xmlns" => "http://scout.wisc.edu/XML/register_v1.0/",
        "xmlns:xsi" => "http://www.w3.org/2001/XMLSchema-instance",
        "xsi:schemaLocation" => "http://scout.wisc.edu/XML/register_v1.0/ http://scout.wisc.edu/XML/schemas/register_v1.0.xsd",
        "schemaVersion" => "1.0",
        );
    $XS->OpenElement("registration", $SchemaInfo);

    # retrieve and add general site info
    $XS->AddElement("software", (SoftwareIsCWIS() ? "CWIS" : "SPT")." ".$SPT_SoftwareVersionToDisplay);
    if ($SysConfig->PortalName()) {  $XS->AddElement("sitename", $SysConfig->PortalName());  }
    $XS->AddElement("siteuri", $HTTP_SERVER_VARS["SERVER_NAME"].dirname($HTTP_SERVER_VARS["REQUEST_URI"]));
    if ($SysConfig->AdminEmail()) {  $XS->AddElement("adminemail", $SysConfig->AdminEmail());  }
    if ($SysConfig->ContactName()) {  $XS->AddElement("contactname", $SysConfig->ContactName());  }
    if ($SysConfig->ContactEmail()) {  $XS->AddElement("contactemail", $SysConfig->ContactEmail());  }
    if ($SysConfig->Organization()) {  $XS->AddElement("organization", $SysConfig->Organization());  }
    if ($SysConfig->OrganizationType()) {  $XS->AddElement("organizationtype", $SysConfig->OrganizationType());  }
    if ($SysConfig->SiteType()) {  $XS->AddElement("sitetype", $SysConfig->SiteType());  }
    $XS->AddElement("okaytolistsite", ($SysConfig->OkayToListSite() ? "TRUE" : "FALSE"));
    $XS->AddElement("registeringuser", $User->Get("UserName"));

    # retrieve and add configuration settings
    $XS->OpenElement("configuration");
    if ($SysConfig->DefaultActiveUI()) {  $XS->AddElement("defaultui", $SysConfig->DefaultActiveUI());  }
    if ($SysConfig->CurrentTheme()) {  $XS->AddElement("currenttheme", $SysConfig->CurrentTheme());  }
    $XS->OpenElement("toggles");
    $XS->AddElement("forums", ($SysConfig->ForumsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("useragents", ($SysConfig->UserAgentsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("announcements", ($SysConfig->AnnouncementsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("multipleuis", ($SysConfig->AllowMultipleUIsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("ratings", ($SysConfig->ResourceRatingsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("comments", ($SysConfig->ResourceCommentsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("searchupdate", ($SysConfig->SearchDBEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("recommenderupdate", ($SysConfig->RecommenderDBEnabled() ? "ENABLED" : "DISABLED"));
    $XS->CloseElement();
    $XS->CloseElement();

    # retrieve and add resource DB info
    $XS->OpenElement("datastatistics");
    $ResourceCount = $DB->Query("SELECT COUNT(*) AS ResourceCount "
            ."FROM Resources", "ResourceCount");
    $XS->AddElement("resourcecount", $ResourceCount);
    $ReleasedResourceCount = $DB->Query("SELECT COUNT(*) AS ResourceCount "
            ."FROM Resources WHERE ReleaseFlag = 1", "ResourceCount");
    $XS->AddElement("releasedresourcecount",$ReleasedResourceCount);
    $RatedResourceCount = $DB->Query("SELECT COUNT(DISTINCT ResourceId) AS ResourceCount "
            ."FROM ResourceRatings", "ResourceCount");
    $XS->AddElement("ratingcount",$RatedResourceCount);
    $ClassCount = $DB->Query("SELECT COUNT(*) AS ClassCount "
            ."FROM Classifications", "ClassCount");
    $XS->AddElement("classificationcount",$ClassCount);
    $SampleCount = $DB->Query("SELECT COUNT(*) AS ResourceCount FROM Resources"
                              ." WHERE INSTR(Description, '[--SAMPLE RECORD--]') > 0",
                              "ResourceCount"); 
    $XS->AddElement("sampleresourcecount",$SampleCount);
    $TermCount = $DB->Query("SELECT COUNT(*) AS TotalCount "
            ."FROM SearchWords", "TotalCount");
    $XS->AddElement("searchtermcount",$TermCount);
    $XS->CloseElement();

    # retrieve and add operating environment info
    $XS->OpenElement("environment");
    $XS->AddElement("phpversion", phpversion());
    $XS->AddElement("httpserver", $HTTP_SERVER_VARS["SERVER_SOFTWARE"]);
    $OSInfo = exec("uname -a");
    $XS->AddElement("osstamp", $OSInfo);
    $XS->OpenElement("mysqlconfig");
    $XS->AddElement("clientversion", mysql_get_client_info());
    $XS->AddElement("serverversion", mysql_get_server_info());
    $XS->AddElement("connectiontype", mysql_get_host_info());
    $XS->CloseElement();
    $XS->CloseElement();

    # add user comments (if any)
    if (strlen($UserEnteredVals["F_Comments"]) > 0)
    {
        $XS->AddElement("comments", $UserEnteredVals["F_Comments"]);
    }
    
    # retrieve XML from XML stream and return to caller
    $XS->CloseElement();
    return $XS->GetContent();
}

# ----- MAIN -----------------------------------------------------------------

# save any user-entered registration values
if (strlen($HTTP_POST_VARS["F_ContactName"])) {  $SysConfig->ContactName($HTTP_POST_VARS["F_ContactName"]);  }
if (strlen($HTTP_POST_VARS["F_ContactEmail"])) {  $SysConfig->ContactEmail($HTTP_POST_VARS["F_ContactEmail"]);  }
if (strlen($HTTP_POST_VARS["F_Organization"])) {  $SysConfig->Organization($HTTP_POST_VARS["F_Organization"]);  }
if (strlen($HTTP_POST_VARS["F_OrganizationType"])) {  $SysConfig->OrganizationType($HTTP_POST_VARS["F_OrganizationType"]);  }
if (strlen($HTTP_POST_VARS["F_SiteType"])) {  $SysConfig->SiteType($HTTP_POST_VARS["F_SiteType"]);  }
$SysConfig->OkayToListSite(isset($HTTP_POST_VARS["F_OkayToListSite"]) ? 1 : 0);

# generate XML containing registration info
$MsgContent = GetRegistrationMessageContent($HTTP_POST_VARS);

# e-mail registration info to Scout
$MsgSubject = (SoftwareIsCWIS() ? "CWIS" : "SPT")." Registration";
if ($SysConfig->PortalName() != "Online Resource Portal")
{
    $MsgSubject .= " (".$SysConfig->PortalName().")";
}
else
{
    $MsgSubject .= " (".$HTTP_SERVER_VARS["SERVER_NAME"].")";
}
mail($RegInfoRecipient, $MsgSubject, $MsgContent,
     "From: ".$SysConfig->AdminEmail()."\r\nReply-To: ".$SysConfig->AdminEmail());

# save registration date
$SysConfig->LastRegisteredOn(date("Y-m-d H:i:s"));

# report success (or failure) to user)
include("include/SPT--StandardHtmlPageLoad.php");


?>
