<?PHP

#
#   FILE:  SPT--Message.php
#
#   FUNCTIONS PROVIDED:
#       Message->Message($MessageId)
#           - constructor
#       Message->MessageId()
#       Message->ParentId()
#       Message->ParentyType()
#       Message->DatePosted()
#       Message->PosterId()
#       Message->Subject()
#       Message->Body()
#           - methods to retrieve resource attributes
#
#   Part of the Scout Portal Toolkit
#   Copyright 2002 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once(dirname(__FILE__)."/../Axis--User.php");


class Message {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    # object constructor
    function Message($MessageId)
    {
        # locate class in database
        $this->DB =& new SPTDatabase();
        $DB =& $this->DB;
        $DB->Query("SELECT * FROM Messages WHERE MessageId = ".$MessageId);

        # load in attributes from database
        $Record = $DB->FetchNextRowArray();
        $this->MessageId =  $MessageId;
        $this->ParentId =   $Record["ParentId"];
        $this->ParentType = $Record["ParentType"];
        $this->DatePosted = $Record["DatePosted"];
        $this->PosterId =   $Record["PosterId"];
        $this->Subject =    $Record["Subject"];
        $this->Body =       $Record["Body"];
    }

    # data access methods
    function MessageId()    {  return $this->MessageId;  }
    function ParentId()     {  return $this->ParentId;  }
    function ParentType()   {  return $this->ParentType;  }
    function DatePosted()   {  return $this->DatePosted;  }
    function PosterId()     {  return $this->PosterId;  }
    function Subject()      {  return $this->Subject;  }
    function Body()         {  return $this->Body;  }

    function PosterName()
    {
        $PosterName =& new User($this->DB, (int)$this->PosterId());
        return $PosterName->Get("UserName");
    }

    function PosterEmail()
    {
        $PosterName =& new User($this->DB, (int)$this->PosterId());
        return $PosterName->Get("Email");
    }

    # ---- PRIVATE INTERFACE -------------------------------------------------

    var $DB;
    var $MessageId;
    var $ParentId;
    var $ParentType;
    var $DatePosted;
    var $PosterId;
    var $Subject;
    var $Body;
}

?>
